/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.MultiRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.request.WriteOnly;

/**
 * 
 * For initiating requests in asynchronous manner. The possible requests are
 * <ul>
 * <li>{@link Read} for computing a single result synchronously
 * <li>{@link AsyncRead} for computing a single result asynchronously
 * <li>{@link MultiRead} for computing a collection of results synchronously
 * <li>{@link AsyncMultiRead} for computing a collection of results
 * asynchronously
 * <li>{@link Write} for reading and writing synchronously
 * <li>{@link WriteOnly} for writing synchronously
 * </ul>
 * <p>
 * The standard AsyncRequestProcessors are
 * <ul>
 * <li>{@link AsyncReadGraph} for performing requests during other requests
 * <li>{@link Session} for initiating a transactions for performing requests
 * <li>{@link MergingGraphRequestProcessor} for merging several requests in a
 * single transaction
 * </ul>
 * 
 * Database services (see e.g. {@link Session}) are available from implemented
 * {@link ServiceLocator}. For a synchronous counterpart with the same
 * functionality as AsyncRequestProcessor see {@link RequestProcessor}
 * 
 * @version 0.7
 * @author Antti Villberg
 * @see Read
 * @see AsyncRead
 * @see MultiRead
 * @see AsyncMultiRead
 * @see Write
 * @see WriteOnly
 * @see AsyncReadGraph
 * @see Session
 * @see MergingGraphRequestProcessor
 * @see RequestProcessor
 */
public interface AsyncRequestProcessor extends ServiceLocator, AsyncRequestProcessorSpecific {

	Resource getRootLibrary();
	
    /**
     * @return the {@link Session} for which this processor is based on.
     */
    Session getSession();
    
    <T> void async(ReadInterface<T> r, Procedure<T> procedure);
    <T> void async(ReadInterface<T> r, AsyncProcedure<T> procedure);
    <T> void async(ReadInterface<T> r, SyncProcedure<T> procedure);
    <T> void async(ReadInterface<T> r, Listener<T> procedure);
    <T> void async(ReadInterface<T> r, AsyncListener<T> procedure);
    <T> void async(ReadInterface<T> r, SyncListener<T> procedure);
    
    <T> void async(WriteInterface<T> r);
    <T> void async(WriteInterface<T> r, Procedure<T> procedure);
    
    Object getModificationCounter();
    
}
