/*******************************************************************************
 * Copyright (c) 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.server.environment;

import java.util.List;

import org.simantics.db.procore.server.environment.windows.Product;


/**
 * @author Tuukka Lehtonen
 */
public class InstallException extends Exception {

    private static final long serialVersionUID = -4189715696439554271L;

    public List<Product> products;

    public InstallException(List<Product> products) {
        super();
        this.products = products;
    }

    public InstallException(String message, List<Product> products) {
        super(message);
        this.products = products;
    }

    public InstallException(Throwable cause, List<Product> products) {
        super(cause);
        this.products = products;
    }

    public InstallException(String message, Throwable cause, List<Product> products) {
        super(message, cause);
        this.products = products;
    }

}
