/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.property.IArrayProperty;
import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.content.LabelDecoratorFactory;
import org.simantics.browsing.ui.graph.impl.contribution.LabelDecoratorContributionImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class PropertyLabelDecoratorFactory
implements LabelDecoratorFactory {
    private static final ColorDescriptor READONLY_GRAY = ColorDescriptor.createFrom((RGB)new RGB(240, 240, 240));

    public LabelDecorator create(PrimitiveQueryUpdater manager, NodeContext context, BuiltinKeys.LabelDecoratorKey key) {
        Object o = context.getConstant(BuiltinKeys.INPUT);
        if (o instanceof IProperty) {
            IArrayProperty array;
            IProperty prop = (IProperty)o;
            if (o instanceof IArrayProperty && (array = (IArrayProperty)o).isSlice()) {
                return null;
            }
            Resource[] data = (Resource[])prop.getData(Resource[].class);
            if (data == null) {
                return null;
            }
            if (data.length != 3) {
                return null;
            }
            return new PropertyReadOnlyLabelDecorator(manager, context, key);
        }
        return null;
    }

    static class PropertyReadOnlyLabelDecorator
    extends LabelDecoratorContributionImpl {
        public PropertyReadOnlyLabelDecorator(PrimitiveQueryUpdater manager, NodeContext context, BuiltinKeys.LabelDecoratorKey key) {
            super(manager, context, key);
        }

        public LabelDecorator getDecorator(ReadGraph graph, NodeContext context) throws DatabaseException {
            IProperty prop = (IProperty)context.getConstant(BuiltinKeys.INPUT);
            Resource[] data = (Resource[])prop.getData(Resource[].class);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Object o = graph.getPossibleRelatedValue2(data[1], L0.readOnly, (Binding)Bindings.BOOLEAN);
            if (!Boolean.TRUE.equals(o)) {
                return null;
            }
            return new LabelDecorator.Stub(){

                public <C> C decorateForeground(C color, String column, int itemIndex) {
                    return null;
                }

                public <C> C decorateBackground(C color, String column, int itemIndex) {
                    if ("Value".equals(column)) {
                        return (C)READONLY_GRAY;
                    }
                    return null;
                }
            };
        }
    }
}

