/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.swt.InputSourceImpl;
import org.simantics.browsing.ui.swt.ModelledControl;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.browsing.ui.swt.widgets.ModelBrowser;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;

public class ModelledGraphExplorerComposite
implements ModelledControl {
    private final Resource configuration;

    public ModelledGraphExplorerComposite(Resource configuration) {
        this.configuration = configuration;
    }

    public Composite create(Composite parent, IWorkbenchSite site, ISessionContext context, final WidgetSupport support) throws DatabaseException {
        String selectionParameter;
        int style = (Integer)Simantics.getSession().syncRequest((Read)new Read<Integer>(){

            public Integer perform(ReadGraph graph) throws DatabaseException {
                int style = 67586;
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Boolean check = (Boolean)graph.getPossibleRelatedValue(ModelledGraphExplorerComposite.this.configuration, br.GraphExplorerComposite_Check, (Binding)Bindings.BOOLEAN);
                if (check != null && check.booleanValue()) {
                    style |= 0x20;
                }
                return style;
            }
        });
        Map args = (Map)Simantics.getSession().syncRequest((Read)new Read<Map<String, Object>>(){

            public Map<String, Object> perform(ReadGraph graph) throws DatabaseException {
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("displaySelectors", Boolean.FALSE);
                args.put("displayFilter", Boolean.FALSE);
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Boolean displayFilter = (Boolean)graph.getPossibleRelatedValue(ModelledGraphExplorerComposite.this.configuration, br.GraphExplorerComposite_DisplayFilter, (Binding)Bindings.BOOLEAN);
                if (displayFilter != null) {
                    args.put("displayFilter", displayFilter);
                }
                return args;
            }
        });
        String browseContextURI = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Resource browseContext = graph.getSingleObject(ModelledGraphExplorerComposite.this.configuration, br.GraphExplorerComposite_BrowseContext);
                return graph.getURI(browseContext);
            }
        });
        ModelBrowser explorer = new ModelBrowser(Collections.singleton(browseContextURI), args, site, parent, support, style){

            @Override
            protected void addListeners(GraphExplorer explorer, IMenuManager menuManager) {
            }
        };
        GridData gridData = (GridData)Simantics.getSession().syncRequest((Read)new Read<GridData>(){

            public GridData perform(ReadGraph graph) throws DatabaseException {
                Integer preferredWidth;
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                GridData data = new GridData(4, 4, true, true);
                Integer span = (Integer)graph.getPossibleRelatedValue(ModelledGraphExplorerComposite.this.configuration, br.Control_HorizontalSpan, (Binding)Bindings.INTEGER);
                if (span != null) {
                    data.horizontalSpan = span;
                }
                data.widthHint = (preferredWidth = (Integer)graph.getPossibleRelatedValue(ModelledGraphExplorerComposite.this.configuration, br.Control_PreferredWidth, (Binding)Bindings.INTEGER)) != null ? preferredWidth : -1;
                Integer preferredHeight = (Integer)graph.getPossibleRelatedValue(ModelledGraphExplorerComposite.this.configuration, br.Control_PreferredHeight, (Binding)Bindings.INTEGER);
                data.heightHint = preferredHeight != null ? preferredHeight : -1;
                return data;
            }
        });
        explorer.setLayoutData(gridData);
        explorer.setInputSource(new InputSourceImpl<Object>(){

            @Override
            public Object get(ISessionContext ctx, Object selection) {
                new Exception("" + selection).printStackTrace();
                return selection;
            }
        });
        Listener selectionListener = (Listener)Simantics.getSession().syncRequest((Read)new Read<Listener>(){

            public Listener perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Resource listener = graph.getPossibleObject(ModelledGraphExplorerComposite.this.configuration, br.GraphExplorerComposite_SelectionListener);
                if (listener == null) {
                    return null;
                }
                return (Listener)graph.adapt(listener, Listener.class);
            }
        });
        if (selectionListener != null) {
            explorer.addListenerToControl(13, selectionListener);
        }
        if ((selectionParameter = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Resource parameter = graph.getPossibleObject(ModelledGraphExplorerComposite.this.configuration, br.GraphExplorerComposite_SelectionParameter);
                if (parameter == null) {
                    return null;
                }
                return graph.getPossibleURI(parameter);
            }
        })) != null) {
            IPostSelectionProvider selectionProvider = (IPostSelectionProvider)explorer.getExplorer().getAdapter(IPostSelectionProvider.class);
            selectionProvider.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    support.setParameter(selectionParameter, selection);
                }
            });
        }
        explorer.finish();
        return explorer;
    }
}

