/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.platform;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.simantics.browsing.ui.platform.VariablesPage;
import org.simantics.browsing.ui.swt.IVariablesPage;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.ui.workbench.ResourceInput;
import org.simantics.utils.ui.BundleUtils;

public class VariablesPageView
extends PageBookView
implements ISelectionListener {
    private static final String VARIABLES_VIEW_CONTEXT = "org.simantics.browsing.ui.variables";
    private static final String PROP_PINNED = "pinned";
    protected static final long SELECTION_CHANGE_THRESHOLD = 500L;
    private ISessionContextProvider contextProvider;
    private ISelection bootstrapSelection;
    private final boolean bootstrapOnly = false;
    private IMemento memento;
    private boolean pinSelection = false;
    private IWorkbenchPart lastPart;
    private ISelection lastSelection;
    private ResourceManager resourceManager;
    private ImageDescriptor notPinned;
    private ImageDescriptor pinned;
    long lastSelectionChangeTime = -1000L;
    ISelectionListener immediateSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            long time = System.currentTimeMillis();
            long delta = time - VariablesPageView.this.lastSelectionChangeTime;
            VariablesPageView.this.lastSelectionChangeTime = time;
            if (delta > 500L) {
                VariablesPageView.this.selectionChanged(part, selection);
            }
        }
    };
    IPropertyListener partPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 1) {
                VariablesPageView.this.updateContentDescription(VariablesPageView.this.pinSelection, VariablesPageView.this.lastPart);
            }
        }
    };

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.notPinned = BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.browsing.ui.common", (String)"icons/table_multiple.png");
        this.pinned = BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.browsing.ui.common", (String)"icons/table_multiple_pinned.png");
        IContextService cs = (IContextService)this.getSite().getService(IContextService.class);
        cs.activateContext(VARIABLES_VIEW_CONTEXT);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IContributedContentsView.class) {
            return (T)new IContributedContentsView(){

                public IWorkbenchPart getContributingPart() {
                    return VariablesPageView.this.getContributingEditor();
                }
            };
        }
        if (adapter == ISessionContextProvider.class) {
            return (T)this.contextProvider;
        }
        return (T)super.getAdapter(adapter);
    }

    private IWorkbenchPart getContributingEditor() {
        return this.getCurrentContributingPart();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.memento = memento;
        this.init(site);
    }

    public void init(IViewSite site) throws PartInitException {
        String secondaryId = site.getSecondaryId();
        if (secondaryId != null) {
            ResourceInput resourceInput = ResourceInput.unmarshall((String)secondaryId);
        }
        super.init(site);
        site.setSelectionProvider(null);
        this.contextProvider = SimanticsUI.getSessionContextProvider();
        site.getPage().addSelectionListener(this.immediateSelectionListener);
        site.getPage().addPostSelectionListener((ISelectionListener)this);
    }

    public void saveState(IMemento memento) {
        if (this.memento != null) {
            memento.putMemento(this.memento);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.lastPart != null) {
            this.lastPart.removePropertyListener(this.partPropertyListener);
        }
        this.contextProvider = null;
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removeSelectionListener(this.immediateSelectionListener);
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        VariablesPage page = new VariablesPage(this.getSite(), (IAdaptable)this);
        page.setAdapter((IAdaptable)this);
        this.initPage(page);
        page.createControl((Composite)book);
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPropertyPage page = (IPropertyPage)pageRecord.page;
        page.dispose();
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            this.bootstrapSelection = page.getSelection();
            return page.getActivePart();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        if (this.pinSelection) {
            return false;
        }
        return part != this;
    }

    public void partActivated(IWorkbenchPart part) {
        IWorkbenchPart source = this.getSourcePart(part);
        super.partActivated(source);
        if (this.bootstrapSelection != null) {
            IPage page = this.getCurrentPage();
            if (page instanceof IPropertyPage) {
                IPropertyPage ppage = (IPropertyPage)page;
                ppage.selectionChanged(part, this.bootstrapSelection);
            }
            this.bootstrapSelection = null;
        }
    }

    protected void partHidden(IWorkbenchPart part) {
        if (!this.pinSelection) {
            super.partHidden(part);
        }
    }

    public ISelection getLastSelection() {
        return this.lastSelection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        if (part == this || sel == null) {
            return;
        }
        if (this.pinSelection) {
            return;
        }
        IPage page = this.getCurrentPage();
        if (page instanceof IVariablesPage) {
            IVariablesPage ppage = (IVariablesPage)page;
            ppage.selectionChanged(part, sel);
            boolean sameSelection = false;
            if (part == this.lastPart && sel != null && sel.equals(this.lastSelection)) {
                sameSelection = true;
            }
            if (this.lastPart != null) {
                this.lastPart.removePropertyListener(this.partPropertyListener);
            }
            this.lastPart = part;
            this.lastSelection = sel;
            if (this.lastPart != null) {
                this.lastPart.addPropertyListener(this.partPropertyListener);
            }
            if (!sameSelection) {
                Display d = this.getSite().getShell().getDisplay();
                ppage.updatePartName(sel, parameter -> {
                    if (!d.isDisposed()) {
                        d.asyncExec(() -> this.doSetPartName((String)parameter));
                    }
                });
            }
        }
    }

    void doSetPartName(String partName) {
        if (this.contextProvider == null) {
            return;
        }
        if (partName == null) {
            partName = "Selection";
        }
        this.setPartName(partName);
    }

    public boolean isWorkbenchSelectionPinned() {
        return this.pinSelection;
    }

    public void pinWorkbenchSelection(boolean pin) {
        if (pin == this.pinSelection) {
            return;
        }
        this.pinSelection = pin;
        this.setPartProperty(PROP_PINNED, Boolean.toString(pin));
        if (pin) {
            this.setTitleImage(this.resourceManager.createImage(this.pinned));
        } else {
            this.setTitleImage(this.resourceManager.createImage(this.notPinned));
        }
        this.updateContentDescription(pin, this.lastPart);
        if (this.lastPart != null) {
            this.lastPart.removePropertyListener(this.partPropertyListener);
        }
        this.lastPart = null;
    }

    IWorkbenchPart getSourcePart(IWorkbenchPart part) {
        IWorkbenchPart source;
        IContributedContentsView view = (IContributedContentsView)part.getAdapter(IContributedContentsView.class);
        if (view != null && (source = view.getContributingPart()) != null) {
            return source;
        }
        return part;
    }

    private void updateContentDescription(boolean selectionPinned, IWorkbenchPart sourcePart) {
        if (selectionPinned) {
            if (sourcePart == null) {
                this.setContentDescription("No selection");
            } else {
                sourcePart = this.getSourcePart(sourcePart);
                StringBuilder desc = new StringBuilder("Selection from ");
                if (sourcePart instanceof IEditorPart) {
                    desc.append("editor ");
                }
                if (sourcePart instanceof IViewPart) {
                    desc.append("view ");
                }
                desc.append('\'');
                desc.append(sourcePart.getTitle());
                desc.append('\'');
                this.setContentDescription(desc.toString());
            }
        } else {
            this.setContentDescription("");
        }
    }
}

