/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.backup.db;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.Simantics;
import org.simantics.backup.BackupException;
import org.simantics.backup.Backups;
import org.simantics.backup.IBackupProvider;
import org.simantics.backup.ontology.BackupResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;

public class ModelledBackupProvider
implements IBackupProvider {
    List<IBackupProvider> modelledBackups = this.getModelledBackups();

    public void lock() throws BackupException {
        Backups.lock(this.modelledBackups);
    }

    public Future<BackupException> backup(Path targetPath, int revision) throws BackupException {
        final ArrayList<Future> backups = new ArrayList<Future>();
        final ArrayList<BackupException> exceptions = new ArrayList<BackupException>(backups.size());
        for (IBackupProvider modelledBackup : this.modelledBackups) {
            try {
                Future future = modelledBackup.backup(targetPath, revision);
                backups.add(future);
            }
            catch (BackupException e) {
                exceptions.add(e);
            }
        }
        FutureTask<BackupException> task = new FutureTask<BackupException>(new Callable<BackupException>(){

            @Override
            public BackupException call() throws Exception {
                for (Future f : backups) {
                    try {
                        Exception exception = (Exception)f.get();
                        if (exception == null) continue;
                        exceptions.add(exception);
                    }
                    catch (InterruptedException | ExecutionException e2) {
                        exceptions.add(e2);
                    }
                }
                BackupException problem = null;
                if (!exceptions.isEmpty()) {
                    IStatus[] ss = (IStatus[])exceptions.stream().map(e -> new Status(4, "org.simantics.backup", e.getMessage(), (Throwable)e)).toArray(IStatus[]::new);
                    problem = new BackupException((Throwable)new CoreException((IStatus)new MultiStatus("org.simantics.backup", 0, ss, "Backup operation(s) failed to complete.", null)));
                }
                return problem;
            }
        });
        new Thread(task).run();
        return task;
    }

    public void unlock() throws BackupException {
        Backups.unlock(this.modelledBackups);
    }

    public void restore(Path fromPath, int revision) throws BackupException {
        for (IBackupProvider modelledBackup : this.modelledBackups) {
            modelledBackup.restore(fromPath, revision);
        }
    }

    private List<IBackupProvider> getModelledBackups() {
        List<Object> modelledProviders = new ArrayList<IBackupProvider>(0);
        try {
            modelledProviders = (List)Simantics.getSession().syncRequest((Read)new UniqueRead<List<IBackupProvider>>(){

                public List<IBackupProvider> perform(ReadGraph graph) throws DatabaseException {
                    BackupResource BACKUP = BackupResource.getInstance((ReadGraph)graph);
                    Instances query = (Instances)graph.adapt(BACKUP.ModelledBackupProvider, Instances.class);
                    HashSet<Resource> providers = new HashSet<Resource>();
                    List ontologies = Layer0Utils.listOntologies((ReadGraph)graph);
                    for (Resource ontology : ontologies) {
                        for (Resource provider : query.find(graph, ontology)) {
                            providers.add(provider);
                        }
                    }
                    ArrayList<IBackupProvider> modelledBackups = new ArrayList<IBackupProvider>();
                    for (Resource provider : providers) {
                        Variable variable = Variables.getVariable((ReadGraph)graph, (Resource)provider);
                        IBackupProvider modelledBackup = (IBackupProvider)variable.getPropertyValue(graph, "instance");
                        modelledBackups.add(modelledBackup);
                    }
                    return modelledBackups;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return modelledProviders;
    }
}

