/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.annotation.ui.diagram.handlers;

import java.util.Collection;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.annotation.ui.AnnotationUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.function.PredefinedVariables;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;

public class NewAnnotation extends AbstractHandler {
	Resource anno = null;
	Resource strConnection = null;
	Resource model = null;
	
	@Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
		
		ISelection selection = HandlerUtil.getCurrentSelection(event);
        final Resource parent = ResourceAdaptionUtils.toSingleResource(selection);
        if(parent == null) return null;
        
        try {
        	
			Simantics.getSession().syncRequest(new ReadRequest() {

				@Override
				public void run(ReadGraph graph) throws DatabaseException {
					
					Variable parentV = Variables.getVariable(graph, parent);
					
					model = Variables.getModel(graph, parentV);

					ConnectionUtil cu = new ConnectionUtil(graph);
			        Collection<Resource> connectors = cu.getTerminalConnectors(parent, null);
			    	Resource connection = null;
			        for (Resource connector : connectors) {
			            connection = ConnectionUtil.tryGetConnection(graph, connector);
			            if (connection != null)
			                break;
			        }
			        if (connection == null)
			        	return;
			        
			        ModelingResources MOD = ModelingResources.getInstance(graph);
			        strConnection = graph.getPossibleObject(connection, MOD.DiagramConnectionToConnection);
			        if (strConnection == null)
			        	return;
			        
			        anno = PredefinedVariables.getAnnotation(graph, parent);
				}
			});

	        if (strConnection == null)
	        	return null;
	        if (anno == null)
	            AnnotationUtils.newAnnotation(parent, model);

		} catch (DatabaseException e) {
			ErrorLogger.defaultLogError(e);
		}

        return null;
    }

}
