/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.pythonlink;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.pythonlink.NDArray;
import org.simantics.pythonlink.PythonException;
import org.simantics.pythonlink.SCLReportingWriter;
import org.simantics.scl.runtime.SCLContext;

public class PythonContext
implements Closeable {
    protected static final String PYTHON_SCL_WRITER = "python.scl.writer";
    private static Boolean isPyInitialized = false;
    private static final Writer pythonWriter = new Writer(){
        Writer defaultWriter = new OutputStreamWriter(System.out);

        @Override
        public void close() throws IOException {
            throw new IllegalStateException("This writer should never be closed!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Writer writer;
            Writer writer2 = writer = this.getPythonWriter();
            synchronized (writer2) {
                writer.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            Writer writer;
            Writer writer2 = writer = this.getPythonWriter();
            synchronized (writer2) {
                writer.write(cbuf, off, len);
            }
        }

        private Writer getPythonWriter() {
            SCLContext sclContext = SCLContext.getCurrent();
            Writer writer = (Writer)sclContext.get((Object)PythonContext.PYTHON_SCL_WRITER);
            return writer != null ? writer : this.defaultWriter;
        }
    };
    Set<Listener> listeners = new HashSet<Listener>();
    static Pattern namePattern = Pattern.compile("([a-zA-Z_][a-zA-Z_0-9]*)");
    private long contextID;
    static final ExecutorService pythonExecutor = Executors.newSingleThreadExecutor();

    private static synchronized void ensurePythonInit() {
        if (!isPyInitialized.booleanValue()) {
            PythonContext.execute(() -> PythonContext.initializePython(pythonWriter));
            isPyInitialized = true;
        }
    }

    PythonContext() {
        PythonContext.ensurePythonInit();
        this.contextID = PythonContext.execute(() -> PythonContext.createContextImpl());
        if (this.contextID == 0L) {
            throw new PythonException("Python initialization has failed");
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void close() {
        long id = this.contextID;
        this.contextID = 0L;
        if (id != 0L) {
            PythonContext.execute(() -> PythonContext.deleteContextImpl(id));
        }
        for (Listener l : this.listeners) {
            l.closed();
        }
    }

    public boolean isOpen() {
        return this.contextID != 0L;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void executePythonStatement(String statement, Writer writer) {
        SCLContext sclContext = SCLContext.getCurrent();
        PythonContext.execute(() -> {
            block11: {
                SCLContext.push((SCLContext)sclContext);
                Writer oldWriter = (Writer)sclContext.put((Object)PYTHON_SCL_WRITER, (Object)writer);
                try {
                    try {
                        PythonContext.executePythonStatementImpl(this.contextID, statement);
                        pythonWriter.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (oldWriter != null) {
                            sclContext.put((Object)PYTHON_SCL_WRITER, (Object)oldWriter);
                        } else {
                            sclContext.remove((Object)PYTHON_SCL_WRITER);
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (oldWriter != null) {
                        sclContext.put((Object)PYTHON_SCL_WRITER, (Object)oldWriter);
                    } else {
                        sclContext.remove((Object)PYTHON_SCL_WRITER);
                    }
                    throw throwable;
                }
                if (oldWriter != null) {
                    sclContext.put((Object)PYTHON_SCL_WRITER, (Object)oldWriter);
                } else {
                    sclContext.remove((Object)PYTHON_SCL_WRITER);
                }
            }
            SCLContext.pop();
        });
        for (Listener l : this.listeners) {
            l.updated(null);
        }
    }

    public void executePythonStatement(String statement) {
        this.executePythonStatement(statement, new SCLReportingWriter());
    }

    public void setPythonBooleanVariable(String variableName, boolean value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> PythonContext.setPythonBooleanVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonIntegerVariable(String variableName, int value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> PythonContext.setPythonLongVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonLongVariable(String variableName, long value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> PythonContext.setPythonLongVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonDoubleVariable(String variableName, double value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> PythonContext.setPythonDoubleVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonStringVariable(String variableName, String value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> PythonContext.setPythonStringVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonBooleanArrayVariable(String variableName, boolean[] value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> PythonContext.setPythonBooleanArrayVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonIntegerArrayVariable(String variableName, int[] value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> PythonContext.setPythonIntegerArrayVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonLongArrayVariable(String variableName, long[] value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> PythonContext.setPythonLongArrayVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonDoubleArrayVariable(String variableName, double[] value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> PythonContext.setPythonDoubleArrayVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public void setPythonStringArrayVariable(String variableName, String[] value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> PythonContext.setPythonStringArrayVariableImpl(this.contextID, variableName, value));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public boolean getPythonBooleanVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.getPythonBooleanVariableImpl(this.contextID, variableName);
    }

    public int getPythonIntegerVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        long value = PythonContext.execute(() -> PythonContext.getPythonLongVariableImpl(this.contextID, variableName));
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new RuntimeException("Python value not in integer range");
        }
        return (int)value;
    }

    public long getPythonLongVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> PythonContext.getPythonLongVariableImpl(this.contextID, variableName));
    }

    public double getPythonDoubleVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> PythonContext.getPythonDoubleVariableImpl(this.contextID, variableName));
    }

    public String getPythonStringVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> PythonContext.getPythonStringVariableImpl(this.contextID, variableName));
    }

    public boolean[] getPythonBooleanArrayVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> PythonContext.getPythonBooleanArrayVariableImpl(this.contextID, variableName));
    }

    public int[] getPythonIntegerArrayVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> PythonContext.getPythonIntegerArrayVariableImpl(this.contextID, variableName));
    }

    public long[] getPythonLongArrayVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> PythonContext.getPythonLongArrayVariableImpl(this.contextID, variableName));
    }

    public double[] getPythonDoubleArrayVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> PythonContext.getPythonDoubleArrayVariableImpl(this.contextID, variableName));
    }

    public String[] getPythonStringArrayVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> PythonContext.getPythonStringArrayVariableImpl(this.contextID, variableName));
    }

    public void setPythonNDArrayVariable(String variableName, NDArray value) {
        PythonContext.checkValidName(variableName);
        PythonContext.execute(() -> PythonContext.setPythonNDArrayVariableImpl(this.contextID, variableName, value));
    }

    public NDArray getPythonNDArrayVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return PythonContext.execute(() -> PythonContext.getPythonNDArrayVariableImpl(this.contextID, variableName));
    }

    public Object getPythonVariantVariable(String variableName, Binding binding) {
        PythonContext.checkValidName(variableName);
        Object result = PythonContext.execute(() -> PythonContext.getPythonVariantVariableImpl(this.contextID, variableName));
        try {
            return Bindings.OBJECT.getContent(result, binding);
        }
        catch (BindingException e) {
            throw new RuntimeException(e);
        }
    }

    public Variant getPythonVariantVariable(String variableName) {
        PythonContext.checkValidName(variableName);
        return Variant.ofInstance((Object)PythonContext.execute(() -> PythonContext.getPythonVariantVariableImpl(this.contextID, variableName)));
    }

    public void setPythonVariantVariable(String variableName, Variant value) {
        this.setPythonVariantVariable(variableName, value.getValue(), value.getBinding());
    }

    public void setPythonVariantVariable(String variableName, Object value, Binding binding) {
        PythonContext.checkValidName(variableName);
        if (!binding.isInstance(value)) {
            throw new IllegalArgumentException("Invalid object binding");
        }
        PythonContext.execute(() -> PythonContext.setPythonVariantVariableImpl(this.contextID, variableName, value, binding));
        for (Listener l : this.listeners) {
            l.updated(variableName);
        }
    }

    public VariableType getPythonVariableType(String variableName) {
        PythonContext.checkValidName(variableName);
        int code = PythonContext.execute(() -> PythonContext.getPythonVariableTypeImpl(this.contextID, variableName));
        VariableType[] values = VariableType.values();
        if (code < 0 || code >= values.length) {
            return VariableType.UNKNOWN;
        }
        return values[code];
    }

    public String[] getPythonVariableNames() {
        return PythonContext.execute(() -> PythonContext.getPythonVariableNamesImpl(this.contextID));
    }

    private static void checkValidName(String variableName) {
        if (!namePattern.matcher(variableName).matches()) {
            throw new IllegalArgumentException("Invalid Python variable name " + variableName);
        }
    }

    static void execute(Runnable job) {
        try {
            pythonExecutor.submit(job).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    static <V> V execute(Callable<V> job) {
        try {
            return pythonExecutor.submit(job).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static native void initializePython(Writer var0);

    private static native long createContextImpl();

    private static native void deleteContextImpl(long var0);

    private static native int executePythonStatementImpl(long var0, String var2);

    private static native void setPythonBooleanVariableImpl(long var0, String var2, boolean var3);

    private static native void setPythonLongVariableImpl(long var0, String var2, long var3);

    private static native void setPythonDoubleVariableImpl(long var0, String var2, double var3);

    private static native void setPythonStringVariableImpl(long var0, String var2, String var3);

    private static native void setPythonBooleanArrayVariableImpl(long var0, String var2, boolean[] var3);

    private static native void setPythonIntegerArrayVariableImpl(long var0, String var2, int[] var3);

    private static native void setPythonLongArrayVariableImpl(long var0, String var2, long[] var3);

    private static native void setPythonDoubleArrayVariableImpl(long var0, String var2, double[] var3);

    private static native void setPythonStringArrayVariableImpl(long var0, String var2, String[] var3);

    private static native boolean getPythonBooleanVariableImpl(long var0, String var2);

    private static native long getPythonLongVariableImpl(long var0, String var2);

    private static native double getPythonDoubleVariableImpl(long var0, String var2);

    private static native String getPythonStringVariableImpl(long var0, String var2);

    private static native boolean[] getPythonBooleanArrayVariableImpl(long var0, String var2);

    private static native long[] getPythonLongArrayVariableImpl(long var0, String var2);

    private static native int[] getPythonIntegerArrayVariableImpl(long var0, String var2);

    private static native double[] getPythonDoubleArrayVariableImpl(long var0, String var2);

    private static native String[] getPythonStringArrayVariableImpl(long var0, String var2);

    private static native void setPythonNDArrayVariableImpl(long var0, String var2, NDArray var3);

    private static native NDArray getPythonNDArrayVariableImpl(long var0, String var2);

    private static native void setPythonVariantVariableImpl(long var0, String var2, Object var3, Binding var4);

    private static native Object getPythonVariantVariableImpl(long var0, String var2);

    private static native int getPythonVariableTypeImpl(long var0, String var2);

    private static native String[] getPythonVariableNamesImpl(long var0);

    public static interface Listener {
        public void updated(String var1);

        public void closed();
    }

    public static enum VariableType {
        NO_VARIABLE,
        BOOLEAN,
        LONG,
        FLOAT,
        STRING,
        BYTEARRAY,
        DICTIONARY,
        NDARRAY,
        SEQUENCE,
        UNKNOWN;

    }
}

