/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.pythonlink;

import java.util.Arrays;

public class NDArray {
    int[] dims;
    double[] value;

    public NDArray(double[] value) {
        this.value = value;
        this.dims = new int[]{value.length};
    }

    public NDArray(int m, int n, double[] value) {
        if (n * m != value.length) {
            throw new IllegalArgumentException("Invalid dimensions for data vector");
        }
        this.value = value;
        this.dims = new int[]{m, n};
    }

    public NDArray(int[] dims, double[] value) {
        int l = dims.length > 0 ? 1 : 0;
        int[] nArray = dims;
        int n = dims.length;
        int n2 = 0;
        while (n2 < n) {
            int d = nArray[n2];
            l *= d;
            ++n2;
        }
        if (l != value.length) {
            throw new IllegalArgumentException("Invalid dimensions for data vector");
        }
        this.dims = dims;
        this.value = value;
    }

    public int size() {
        return this.value.length;
    }

    public int[] dims() {
        return this.dims;
    }

    public double[] getValues() {
        return this.value;
    }

    public double getValue(int index) {
        return this.value[index];
    }

    public double getValue(int i, int j) {
        if (this.dims.length != 2) {
            throw new IllegalArgumentException("Invalid indices for array of dimension " + this.dims.length);
        }
        return this.value[this.dims[1] * i + j];
    }

    public double getValue(int ... is) {
        if (this.dims.length != is.length) {
            throw new IllegalArgumentException("Invalid indices for array of dimension " + this.dims.length);
        }
        int index = 0;
        int k = 0;
        while (k < this.dims.length) {
            index = this.dims[k] * index + is[k];
            ++k;
        }
        return this.value[index];
    }

    public boolean equals(Object o) {
        return o instanceof NDArray && Arrays.equals(this.dims, ((NDArray)o).dims) && Arrays.equals(this.value, ((NDArray)o).value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.dims) + 11 * Arrays.hashCode(this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ndarray(");
        int i = 0;
        while (i < this.dims.length) {
            if (i > 0) {
                sb.append('x');
            }
            sb.append(this.dims[i]);
            ++i;
        }
        sb.append(") ");
        if (this.dims.length > 0) {
            this.buildString(sb, 0, 0);
        } else {
            sb.append("[]");
        }
        return sb.toString();
    }

    private void buildString(StringBuilder sb, int d, int i) {
        if (d == this.dims.length) {
            sb.append(this.value[i]);
        } else {
            i *= this.dims[d];
            sb.append('[');
            int j = 0;
            while (j < this.dims[d]) {
                if (j > 0) {
                    sb.append(", ");
                }
                this.buildString(sb, d + 1, i + j);
                ++j;
            }
            sb.append(']');
        }
    }
}

