/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class LocationAwareContentHandler
extends DefaultHandler2 {
    public static final String LINE_NUMBER_KEY_NAME = "ln";
    public static final String COLUMN_NUMBER_KEY_NAME = "cn";
    public static final String DOCTYPE_KEY_NAME = "dt";
    public static final String NAMESPACE_KEY_NAME = "nsuri";
    private final Set<String> namespaceURIs = new HashSet<String>();
    private final Document doc;
    private Locator locator;
    private Element current;
    private Doctype doctype;

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        this.doctype = new Doctype(name, publicId, systemId, baseURI);
        this.doc.setUserData(DOCTYPE_KEY_NAME, this.doctype, null);
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    public LocationAwareContentHandler(Document d) {
        this.doc = d;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Element e = null;
        e = localName != null && !"".equals(localName) ? this.doc.createElementNS(uri, localName) : this.doc.createElement(qName);
        this.storeLineInformation(e);
        if (StringUtils.isNotBlank((CharSequence)uri)) {
            this.namespaceURIs.add(uri);
        }
        if (this.doc.getUserData(NAMESPACE_KEY_NAME) == null) {
            this.doc.setUserData(NAMESPACE_KEY_NAME, this.namespaceURIs, null);
        }
        if (this.current == null) {
            this.doc.appendChild(e);
        } else {
            this.current.appendChild(e);
        }
        this.current = e;
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = null;
                if (attrs.getLocalName(i) != null && !"".equals(attrs.getLocalName(i))) {
                    attr = this.doc.createAttributeNS(attrs.getURI(i), attrs.getLocalName(i));
                    attr.setValue(attrs.getValue(i));
                    this.storeLineInformation(attr);
                    this.current.setAttributeNodeNS(attr);
                    continue;
                }
                attr = this.doc.createAttribute(attrs.getQName(i));
                attr.setValue(attrs.getValue(i));
                this.storeLineInformation(attr);
                this.current.setAttributeNode(attr);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.current == null) {
            return;
        }
        Node parent = this.current.getParentNode();
        if (parent.getParentNode() == null) {
            this.current.normalize();
            this.current = null;
        } else {
            this.current = (Element)this.current.getParentNode();
        }
    }

    private void storeLineInformation(Node e) {
        e.setUserData(LINE_NUMBER_KEY_NAME, this.locator.getLineNumber(), null);
        e.setUserData(COLUMN_NUMBER_KEY_NAME, this.locator.getColumnNumber(), null);
    }

    @Override
    public void characters(char[] buf, int offset, int length) {
        if (this.current != null) {
            Text n = this.doc.createTextNode(new String(buf, offset, length));
            this.storeLineInformation(n);
            this.current.appendChild(n);
        }
    }

    public class Doctype {
        public String name;
        public String publicId;
        public String systemId;
        public String baseURI;

        public Doctype(String name, String publicId, String systemId, String baseURI) {
            this.name = name;
            this.publicId = publicId;
            this.systemId = systemId;
            this.baseURI = baseURI;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        public String getBaseURI() {
            return this.baseURI;
        }

        public void setBaseURI(String baseURI) {
            this.baseURI = baseURI;
        }

        public String toString() {
            return "Doctype [name=" + this.name + ", publicId=" + this.publicId + ", systemId=" + this.systemId + ", baseURI=" + this.baseURI + "]";
        }
    }
}

