/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.ArrayUtilities;
import com.strobel.reflection.PrimitiveType;
import com.strobel.reflection.Type;
import java.util.List;
import javax.lang.model.type.TypeKind;

public final class PrimitiveTypes {
    public static final Type<Void> Void = new PrimitiveType<Void>(java.lang.Void.TYPE, 'V', "void", TypeKind.VOID);
    public static final Type<Boolean> Boolean = new PrimitiveType<Boolean>(java.lang.Boolean.TYPE, 'Z', "boolean", TypeKind.BOOLEAN);
    public static final Type<Byte> Byte = new PrimitiveType<Byte>(java.lang.Byte.TYPE, 'B', "byte", TypeKind.BYTE);
    public static final Type<Short> Short = new PrimitiveType<Short>(java.lang.Short.TYPE, 'S', "short", TypeKind.SHORT);
    public static final Type<Character> Character = new PrimitiveType<Character>(java.lang.Character.TYPE, 'C', "char", TypeKind.CHAR);
    public static final Type<Integer> Integer = new PrimitiveType<Integer>(java.lang.Integer.TYPE, 'I', "int", TypeKind.INT);
    public static final Type<Long> Long = new PrimitiveType<Long>(java.lang.Long.TYPE, 'J', "long", TypeKind.LONG);
    public static final Type<Float> Float = new PrimitiveType<Float>(java.lang.Float.TYPE, 'F', "float", TypeKind.FLOAT);
    public static final Type<Double> Double = new PrimitiveType<Double>(java.lang.Double.TYPE, 'D', "double", TypeKind.DOUBLE);
    private static final List<Type<?>> AllPrimitives = ArrayUtilities.asUnmodifiableList((Object[])new Type[]{Void, Boolean, Byte, Short, Character, Integer, Long, Float, Double});

    private PrimitiveTypes() {
    }

    static void ensureRegistered() {
        if (Void != Type.CACHE.find(java.lang.Void.TYPE)) {
            throw new IllegalStateException("Primitive types were not successfully registered!");
        }
    }

    public static List<Type<?>> allPrimitives() {
        return AllPrimitives;
    }

    static {
        Type.CACHE.add(Void);
        Type.CACHE.add(Boolean);
        Type.CACHE.add(Byte);
        Type.CACHE.add(Short);
        Type.CACHE.add(Character);
        Type.CACHE.add(Integer);
        Type.CACHE.add(Long);
        Type.CACHE.add(Float);
        Type.CACHE.add(Double);
    }
}

