/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Stream;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.Function3;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.block.factory.PrimitiveFunctions;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.factory.primitive.ObjectDoubleMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectLongMaps;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;

public abstract class AbstractMultiReaderMutableCollection<T>
implements MutableCollection<T> {
    protected abstract MutableCollection<T> getDelegate();

    protected abstract ReadWriteLock getLock();

    protected void acquireWriteLock() {
        this.getLock().writeLock().lock();
    }

    protected void unlockWriteLock() {
        this.getLock().writeLock().unlock();
    }

    protected void acquireReadLock() {
        this.getLock().readLock().lock();
    }

    protected void unlockReadLock() {
        this.getLock().readLock().unlock();
    }

    protected void withReadLockRun(Runnable block) {
        this.acquireReadLock();
        try {
            block.run();
        }
        finally {
            this.unlockReadLock();
        }
    }

    public boolean contains(Object item) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().contains(item);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public boolean containsAll(Collection<?> collection) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().containsAll(collection);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public boolean containsAllIterable(Iterable<?> source) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().containsAllIterable(source);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public boolean containsAllArguments(Object ... elements) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().containsAllArguments(elements);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public boolean noneSatisfy(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().noneSatisfy(predicate);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().noneSatisfyWith(predicate, parameter);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public boolean allSatisfy(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().allSatisfy(predicate);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().allSatisfyWith(predicate, parameter);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public boolean anySatisfy(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().anySatisfy(predicate);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().anySatisfyWith(predicate, parameter);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public <R extends Collection<T>> R into(R target) {
        this.acquireReadLock();
        try {
            Collection collection = this.getDelegate().into(target);
            return (R)collection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public MutableList<T> toList() {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.getDelegate().toList();
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        this.acquireReadLock();
        try {
            MutableMap mutableMap = this.getDelegate().toMap(keyFunction, valueFunction);
            return mutableMap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        this.acquireReadLock();
        try {
            MutableSortedMap mutableSortedMap = this.getDelegate().toSortedMap(keyFunction, valueFunction);
            return mutableSortedMap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        this.acquireReadLock();
        try {
            MutableSortedMap mutableSortedMap = this.getDelegate().toSortedMap(comparator, keyFunction, valueFunction);
            return mutableSortedMap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public LazyIterable<T> asLazy() {
        this.acquireReadLock();
        try {
            LazyIterable lazyIterable = this.getDelegate().asLazy();
            return lazyIterable;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public MutableSet<T> toSet() {
        this.acquireReadLock();
        try {
            MutableSet mutableSet = this.getDelegate().toSet();
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public MutableBag<T> toBag() {
        this.acquireReadLock();
        try {
            MutableBag mutableBag = this.getDelegate().toBag();
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public MutableSortedBag<T> toSortedBag() {
        this.acquireReadLock();
        try {
            MutableSortedBag mutableSortedBag = this.getDelegate().toSortedBag();
            return mutableSortedBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
        this.acquireReadLock();
        try {
            MutableSortedBag mutableSortedBag = this.getDelegate().toSortedBag(comparator);
            return mutableSortedBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableSortedBag mutableSortedBag = this.getDelegate().toSortedBagBy(function);
            return mutableSortedBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public MutableList<T> toSortedList() {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.getDelegate().toSortedList();
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.getDelegate().toSortedList(comparator);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.getDelegate().toSortedListBy(function);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public MutableSortedSet<T> toSortedSet() {
        this.acquireReadLock();
        try {
            MutableSortedSet mutableSortedSet = this.getDelegate().toSortedSet();
            return mutableSortedSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        this.acquireReadLock();
        try {
            MutableSortedSet mutableSortedSet = this.getDelegate().toSortedSet(comparator);
            return mutableSortedSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableSortedSet mutableSortedSet = this.getDelegate().toSortedSetBy(function);
            return mutableSortedSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public int count(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            int n = this.getDelegate().count(predicate);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            int n = this.getDelegate().countWith(predicate, parameter);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public T detect(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().detect(predicate);
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().detectWith(predicate, parameter);
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            Optional optional = this.getDelegate().detectOptional(predicate);
            return optional;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> Optional<T> detectWithOptional(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            Optional optional = this.getDelegate().detectWithOptional(predicate, parameter);
            return optional;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().detectIfNone(predicate, function);
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().detectWithIfNone(predicate, parameter, function);
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public T min(Comparator<? super T> comparator) {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().min(comparator);
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public T max(Comparator<? super T> comparator) {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().max(comparator);
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public T min() {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().min();
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public T max() {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().max();
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().minBy(function);
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().maxBy(function);
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public T getFirst() {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().getFirst();
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public T getLast() {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().getLast();
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public T getOnly() {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().getOnly();
            return (T)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public boolean notEmpty() {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().notEmpty();
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> Twin<MutableList<T>> selectAndRejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            Twin twin = this.getDelegate().selectAndRejectWith(predicate, parameter);
            return twin;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
        this.acquireReadLock();
        try {
            Collection collection = this.getDelegate().collect(function, target);
            return (R)collection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
        this.acquireReadLock();
        try {
            MutableBooleanCollection mutableBooleanCollection = this.getDelegate().collectBoolean(booleanFunction, target);
            return (R)mutableBooleanCollection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
        this.acquireReadLock();
        try {
            MutableByteCollection mutableByteCollection = this.getDelegate().collectByte(byteFunction, target);
            return (R)mutableByteCollection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
        this.acquireReadLock();
        try {
            MutableCharCollection mutableCharCollection = this.getDelegate().collectChar(charFunction, target);
            return (R)mutableCharCollection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
        this.acquireReadLock();
        try {
            MutableDoubleCollection mutableDoubleCollection = this.getDelegate().collectDouble(doubleFunction, target);
            return (R)mutableDoubleCollection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
        this.acquireReadLock();
        try {
            MutableFloatCollection mutableFloatCollection = this.getDelegate().collectFloat(floatFunction, target);
            return (R)mutableFloatCollection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
        this.acquireReadLock();
        try {
            MutableIntCollection mutableIntCollection = this.getDelegate().collectInt(intFunction, target);
            return (R)mutableIntCollection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
        this.acquireReadLock();
        try {
            MutableLongCollection mutableLongCollection = this.getDelegate().collectLong(longFunction, target);
            return (R)mutableLongCollection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
        this.acquireReadLock();
        try {
            MutableShortCollection mutableShortCollection = this.getDelegate().collectShort(shortFunction, target);
            return (R)mutableShortCollection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
        this.acquireReadLock();
        try {
            Collection collection = this.getDelegate().flatCollect(function, target);
            return (R)collection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        this.acquireReadLock();
        try {
            Collection collection = this.getDelegate().collectIf(predicate, function, target);
            return (R)collection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, V, R extends Collection<V>> R collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter, R targetCollection) {
        this.acquireReadLock();
        try {
            Collection collection = this.getDelegate().collectWith(function, parameter, targetCollection);
            return (R)collection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        this.acquireReadLock();
        try {
            Collection collection = this.getDelegate().selectWith(predicate, parameter, targetCollection);
            return (R)collection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
        this.acquireReadLock();
        try {
            Collection collection = this.getDelegate().reject(predicate, target);
            return (R)collection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        this.acquireReadLock();
        try {
            Collection collection = this.getDelegate().rejectWith(predicate, parameter, targetCollection);
            return (R)collection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
        this.acquireReadLock();
        try {
            Collection collection = this.getDelegate().select(predicate, target);
            return (R)collection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().injectInto(injectedValue, function);
            return (IV)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> function) {
        this.acquireReadLock();
        try {
            int n = this.getDelegate().injectInto(injectedValue, function);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> function) {
        this.acquireReadLock();
        try {
            long l = this.getDelegate().injectInto(injectedValue, function);
            return l;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> function) {
        this.acquireReadLock();
        try {
            double d = this.getDelegate().injectInto(injectedValue, function);
            return d;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super T> function) {
        this.acquireReadLock();
        try {
            float f = this.getDelegate().injectInto(injectedValue, function);
            return f;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumOfInt(IntFunction<? super T> function) {
        this.acquireReadLock();
        try {
            long l = this.getDelegate().sumOfInt(function);
            return l;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sumOfFloat(FloatFunction<? super T> function) {
        this.acquireReadLock();
        try {
            double d = this.getDelegate().sumOfFloat(function);
            return d;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumOfLong(LongFunction<? super T> function) {
        this.acquireReadLock();
        try {
            long l = this.getDelegate().sumOfLong(function);
            return l;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sumOfDouble(DoubleFunction<? super T> function) {
        this.acquireReadLock();
        try {
            double d = this.getDelegate().sumOfDouble(function);
            return d;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public <V> MutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByIntFunction(groupBy, function));
    }

    public <V> MutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> groupBy, FloatFunction<? super T> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByFloatFunction(groupBy, function));
    }

    public <V> MutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByLongFunction(groupBy, function));
    }

    public <V> MutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> groupBy, DoubleFunction<? super T> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByDoubleFunction(groupBy, function));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        this.acquireReadLock();
        try {
            Object object = this.getDelegate().injectIntoWith(injectValue, function, parameter);
            return (IV)object;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public boolean removeIf(Predicate<? super T> predicate) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().removeIf(predicate);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().removeIfWith(predicate, parameter);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    public boolean add(T item) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().add(item);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    public boolean addAll(Collection<? extends T> collection) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().addAll(collection);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    public boolean addAllIterable(Iterable<? extends T> iterable) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().addAllIterable(iterable);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    public void clear() {
        this.acquireWriteLock();
        try {
            this.getDelegate().clear();
        }
        finally {
            this.unlockWriteLock();
        }
    }

    public boolean isEmpty() {
        this.acquireReadLock();
        try {
            boolean bl = this.getDelegate().isEmpty();
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("Iterator is not supported directly on MultiReader collections.  If you would like to use an iterator, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    public Spliterator<T> spliterator() {
        throw new UnsupportedOperationException("Spliterator is not supported directly on MultiReader collections.  If you would like to use an spliterator, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    public Stream<T> stream() {
        throw new UnsupportedOperationException("Stream is not supported directly on MultiReader collections.  If you would like to use stream, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    public Stream<T> parallelStream() {
        throw new UnsupportedOperationException("parallelStream is not supported directly on MultiReader collections.  If you would like to use parallelStream, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    public boolean remove(Object item) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().remove(item);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    public boolean removeAll(Collection<?> collection) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().removeAll(collection);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    public boolean removeAllIterable(Iterable<?> iterable) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().removeAllIterable(iterable);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    public boolean retainAll(Collection<?> collection) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().retainAll(collection);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    public boolean retainAllIterable(Iterable<?> iterable) {
        this.acquireWriteLock();
        try {
            boolean bl = this.getDelegate().retainAllIterable(iterable);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    public int size() {
        this.acquireReadLock();
        try {
            int n = this.getDelegate().size();
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public Object[] toArray() {
        this.acquireReadLock();
        try {
            Object[] objectArray = this.getDelegate().toArray();
            return objectArray;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public <E> E[] toArray(E[] a) {
        this.acquireReadLock();
        try {
            Object[] objectArray = this.getDelegate().toArray((Object[])a);
            return objectArray;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public void forEach(Procedure<? super T> procedure) {
        this.each(procedure);
    }

    public void each(Procedure<? super T> procedure) {
        this.acquireReadLock();
        try {
            this.getDelegate().forEach(procedure);
        }
        finally {
            this.unlockReadLock();
        }
    }

    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        this.acquireReadLock();
        try {
            this.getDelegate().forEachWith(procedure, parameter);
        }
        finally {
            this.unlockReadLock();
        }
    }

    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        this.acquireReadLock();
        try {
            this.getDelegate().forEachWithIndex(objectIntProcedure);
        }
        finally {
            this.unlockReadLock();
        }
    }

    public String toString() {
        this.acquireReadLock();
        try {
            String string = this.getDelegate().toString();
            return string;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public String makeString() {
        this.acquireReadLock();
        try {
            String string = this.getDelegate().makeString();
            return string;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public String makeString(String separator) {
        this.acquireReadLock();
        try {
            String string = this.getDelegate().makeString(separator);
            return string;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        this.acquireReadLock();
        try {
            String string = this.getDelegate().makeString(start, separator, end);
            return string;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public void appendString(Appendable appendable) {
        this.acquireReadLock();
        try {
            this.getDelegate().appendString(appendable);
        }
        finally {
            this.unlockReadLock();
        }
    }

    public void appendString(Appendable appendable, String separator) {
        this.acquireReadLock();
        try {
            this.getDelegate().appendString(appendable, separator);
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.acquireReadLock();
        try {
            this.getDelegate().appendString(appendable, start, separator, end);
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        this.acquireReadLock();
        try {
            MutableMultimap mutableMultimap = this.getDelegate().groupBy(function, target);
            return (R)mutableMultimap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        this.acquireReadLock();
        try {
            MutableMultimap mutableMultimap = this.getDelegate().groupByEach(function, target);
            return (R)mutableMultimap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends MutableMap<V, T>> R groupByUniqueKey(Function<? super T, ? extends V> function, R target) {
        this.acquireReadLock();
        try {
            MutableMap mutableMap = this.getDelegate().groupByUniqueKey(function, target);
            return (R)mutableMap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        this.acquireReadLock();
        try {
            Collection collection = this.getDelegate().zip(that, target);
            return (R)collection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        this.acquireReadLock();
        try {
            Collection collection = this.getDelegate().zipWithIndex(target);
            return (R)collection;
        }
        finally {
            this.unlockReadLock();
        }
    }

    public <K, V> MutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public <K, V> MutableMap<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    protected static abstract class UntouchableMutableCollection<T>
    implements MutableCollection<T> {
        protected MutableCollection<T> delegate;

        protected UntouchableMutableCollection() {
        }

        public boolean allSatisfy(Predicate<? super T> predicate) {
            return this.delegate.allSatisfy(predicate);
        }

        public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.allSatisfyWith(predicate, parameter);
        }

        public boolean noneSatisfy(Predicate<? super T> predicate) {
            return this.delegate.noneSatisfy(predicate);
        }

        public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.noneSatisfyWith(predicate, parameter);
        }

        public boolean anySatisfy(Predicate<? super T> predicate) {
            return this.delegate.anySatisfy(predicate);
        }

        public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.anySatisfyWith(predicate, parameter);
        }

        public <R extends Collection<T>> R into(R target) {
            return (R)this.delegate.into(target);
        }

        public MutableList<T> toList() {
            return this.delegate.toList();
        }

        public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
            return this.delegate.toMap(keyFunction, valueFunction);
        }

        public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
            return this.delegate.toSortedMap(keyFunction, valueFunction);
        }

        public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
            return this.delegate.toSortedMap(comparator, keyFunction, valueFunction);
        }

        public MutableSet<T> toSet() {
            return this.delegate.toSet();
        }

        public MutableBag<T> toBag() {
            return this.delegate.toBag();
        }

        public MutableSortedBag<T> toSortedBag() {
            return this.delegate.toSortedBag();
        }

        public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
            return this.delegate.toSortedBag(comparator);
        }

        public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
            return this.delegate.toSortedBagBy(function);
        }

        public MutableList<T> toSortedList() {
            return this.delegate.toSortedList();
        }

        public MutableList<T> toSortedList(Comparator<? super T> comparator) {
            return this.delegate.toSortedList(comparator);
        }

        public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
            return this.delegate.toSortedListBy(function);
        }

        public MutableSortedSet<T> toSortedSet() {
            return this.delegate.toSortedSet();
        }

        public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
            return this.delegate.toSortedSet(comparator);
        }

        public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
            return this.delegate.toSortedSetBy(function);
        }

        public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
            return (R)this.delegate.collect(function, target);
        }

        public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
            return (R)this.delegate.flatCollect(function, target);
        }

        public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
            return (R)this.delegate.collectIf(predicate, function, target);
        }

        public <P, V, R extends Collection<V>> R collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter, R targetCollection) {
            return (R)this.delegate.collectWith(function, parameter, targetCollection);
        }

        public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
            return (R)this.delegate.groupBy(function, target);
        }

        public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
            return (R)this.delegate.groupByEach(function, target);
        }

        public <V, R extends MutableMap<V, T>> R groupByUniqueKey(Function<? super T, ? extends V> function, R target) {
            return (R)this.delegate.groupByUniqueKey(function, target);
        }

        public int count(Predicate<? super T> predicate) {
            return this.delegate.count(predicate);
        }

        public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.countWith(predicate, parameter);
        }

        public T detect(Predicate<? super T> predicate) {
            return (T)this.delegate.detect(predicate);
        }

        public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return (T)this.delegate.detectWith(predicate, parameter);
        }

        public Optional<T> detectOptional(Predicate<? super T> predicate) {
            return this.delegate.detectOptional(predicate);
        }

        public <P> Optional<T> detectWithOptional(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.detectWithOptional(predicate, parameter);
        }

        public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
            return (T)this.delegate.detectIfNone(predicate, function);
        }

        public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
            return (T)this.delegate.detectWithIfNone(predicate, parameter, function);
        }

        public T min(Comparator<? super T> comparator) {
            return (T)this.delegate.min(comparator);
        }

        public T max(Comparator<? super T> comparator) {
            return (T)this.delegate.max(comparator);
        }

        public T min() {
            return (T)this.delegate.min();
        }

        public T max() {
            return (T)this.delegate.max();
        }

        public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
            return (T)this.delegate.minBy(function);
        }

        public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
            return (T)this.delegate.maxBy(function);
        }

        public T getFirst() {
            return (T)this.delegate.getFirst();
        }

        public T getLast() {
            return (T)this.delegate.getLast();
        }

        public T getOnly() {
            return (T)this.delegate.getOnly();
        }

        public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
            return (IV)this.delegate.injectInto(injectedValue, function);
        }

        public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super T> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        public long sumOfInt(IntFunction<? super T> function) {
            return this.delegate.sumOfInt(function);
        }

        public double sumOfFloat(FloatFunction<? super T> function) {
            return this.delegate.sumOfFloat(function);
        }

        public long sumOfLong(LongFunction<? super T> function) {
            return this.delegate.sumOfLong(function);
        }

        public double sumOfDouble(DoubleFunction<? super T> function) {
            return this.delegate.sumOfDouble(function);
        }

        public <V> MutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
            return this.delegate.sumByInt(groupBy, function);
        }

        public <V> MutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> groupBy, FloatFunction<? super T> function) {
            return this.delegate.sumByFloat(groupBy, function);
        }

        public <V> MutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
            return this.delegate.sumByLong(groupBy, function);
        }

        public <V> MutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> groupBy, DoubleFunction<? super T> function) {
            return this.delegate.sumByDouble(groupBy, function);
        }

        public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
            return (IV)this.delegate.injectIntoWith(injectValue, function, parameter);
        }

        public boolean notEmpty() {
            return this.delegate.notEmpty();
        }

        public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
            return (R)this.delegate.reject(predicate, target);
        }

        public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
            return (R)this.delegate.rejectWith(predicate, parameter, targetCollection);
        }

        public boolean removeIf(Predicate<? super T> predicate) {
            return this.delegate.removeIf(predicate);
        }

        public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.removeIfWith(predicate, parameter);
        }

        public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
            return (R)this.delegate.select(predicate, target);
        }

        public <P> Twin<MutableList<T>> selectAndRejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.selectAndRejectWith(predicate, parameter);
        }

        public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
            return (R)this.delegate.selectWith(predicate, parameter, targetCollection);
        }

        public boolean add(T o) {
            return this.delegate.add(o);
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.delegate.addAll(collection);
        }

        public boolean addAllIterable(Iterable<? extends T> iterable) {
            return this.delegate.addAllIterable(iterable);
        }

        public void clear() {
            this.delegate.clear();
        }

        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.delegate.containsAll(collection);
        }

        public boolean containsAllIterable(Iterable<?> source) {
            return this.delegate.containsAllIterable(source);
        }

        public boolean containsAllArguments(Object ... elements) {
            return this.delegate.containsAllArguments(elements);
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.delegate.removeAll(collection);
        }

        public boolean removeAllIterable(Iterable<?> iterable) {
            return this.delegate.removeAllIterable(iterable);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.delegate.retainAll(collection);
        }

        public boolean retainAllIterable(Iterable<?> iterable) {
            return this.delegate.retainAllIterable(iterable);
        }

        public int size() {
            return this.delegate.size();
        }

        public Object[] toArray() {
            return this.delegate.toArray();
        }

        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray((Object[])a);
        }

        public void forEach(Procedure<? super T> procedure) {
            this.each(procedure);
        }

        public void each(Procedure<? super T> procedure) {
            this.delegate.forEach(procedure);
        }

        public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
            this.delegate.forEachWith(procedure, parameter);
        }

        public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
            this.delegate.forEachWithIndex(objectIntProcedure);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public String makeString() {
            return this.delegate.makeString();
        }

        public String makeString(String separator) {
            return this.delegate.makeString(separator);
        }

        public String makeString(String start, String separator, String end) {
            return this.delegate.makeString(start, separator, end);
        }

        public void appendString(Appendable appendable) {
            this.delegate.appendString(appendable);
        }

        public void appendString(Appendable appendable, String separator) {
            this.delegate.appendString(appendable, separator);
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            this.delegate.appendString(appendable, start, separator, end);
        }

        public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
            return (R)this.delegate.zip(that, target);
        }

        public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
            return (R)this.delegate.zipWithIndex(target);
        }

        public RichIterable<RichIterable<T>> chunk(int size) {
            return this.delegate.chunk(size);
        }

        public <K, V> MutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
            UnifiedMap map = UnifiedMap.newMap();
            this.each((Procedure & Serializable)each -> {
                Object key = groupBy.valueOf(each);
                Object value = map.getIfAbsentPut(key, zeroValueFactory);
                mutatingAggregator.value(value, each);
            });
            return map;
        }

        public <K, V> MutableMap<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
            UnifiedMap map = UnifiedMap.newMap();
            this.each((Procedure & Serializable)each -> {
                Object key = groupBy.valueOf(each);
                Object value = map.getIfAbsentPut(key, zeroValueFactory);
                map.put(key, nonMutatingAggregator.value(value, each));
            });
            return map;
        }
    }
}

