/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction0;
import org.eclipse.collections.api.block.function.primitive.FloatToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToFloatFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortFloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.ImmutableShortFloatMap;
import org.eclipse.collections.api.map.primitive.ShortFloatMap;
import org.eclipse.collections.api.map.primitive.MutableShortFloatMap;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.ShortFloatPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.factory.primitive.ShortFloatMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableShortFloatMap
        implements MutableShortFloatMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableShortFloatMap map;

    public UnmodifiableShortFloatMap(MutableShortFloatMap map)
    {
        if(map == null)
        {
            throw new IllegalArgumentException("Cannot create a UnmodifiableShortFloatMap on a null map");
        }

        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(short key, float value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ShortFloatMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(short key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(short key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public float removeKeyIfAbsent(short key, float value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public float getIfAbsentPut(short key, float value)
    {
        return this.map.getIfAbsentPut(key, () -> {throw new UnsupportedOperationException();});
    }

    public float getIfAbsentPut(short key, FloatFunction0 function)
    {
        return this.map.getIfAbsentPut(key, () -> {throw new UnsupportedOperationException();});
    }

    public float getIfAbsentPutWithKey(short key, ShortToFloatFunction function)
    {
        return this.map.getIfAbsentPut(key, () -> {throw new UnsupportedOperationException();});
    }

    public <P> float getIfAbsentPutWith(short key, FloatFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, () -> {throw new UnsupportedOperationException();});
    }

    public float updateValue(short key, float initialValueIfAbsent, FloatToFloatFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public float get(short key)
    {
        return this.map.get(key);
    }

    public float getIfAbsent(short key, float ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public float getOrThrow(short key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(short key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(float value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(ShortProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ShortFloatProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyShortIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<ShortFloatPair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableShortFloatMap select(ShortFloatPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableShortFloatMap reject(ShortFloatPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableFloatIterator floatIterator()
    {
        return new UnmodifiableFloatIterator(this.map.floatIterator());
    }

    public void forEach(FloatProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(FloatProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(FloatPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableFloatBag select(FloatPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableFloatBag reject(FloatPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public double sum()
    {
        return this.map.sum();
    }

    public float max()
    {
        return this.map.max();
    }

    public float maxIfEmpty(float defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public float min()
    {
        return this.map.min();
    }

    public float minIfEmpty(float defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public float addToValue(short key, float toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public float[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableFloatList toSortedList()
    {
        return this.map.toSortedList();
    }

    public float[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(float value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(float... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(FloatIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableFloatList toList()
    {
        return this.map.toList();
    }

    public MutableFloatSet toSet()
    {
        return this.map.toSet();
    }

    public MutableFloatBag toBag()
    {
        return this.map.toBag();
    }

    public LazyFloatIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableShortFloatMap withKeyValue(short key, float value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableShortFloatMap withoutKey(short key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableShortFloatMap withoutAllKeys(ShortIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableShortFloatMap asUnmodifiable()
    {
        return this;
    }

    public MutableShortFloatMap asSynchronized()
    {
        return new SynchronizedShortFloatMap(this);
    }

    public ImmutableShortFloatMap toImmutable()
    {
        return ShortFloatMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableShortSet keySet()
    {
        return UnmodifiableShortSet.of(this.map.keySet());
    }

    public MutableFloatCollection values()
    {
        return UnmodifiableFloatCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
