/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableLongShortMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableLongShortMap;
import org.eclipse.collections.api.map.primitive.LongShortMap;

/**
 * ImmutableLongShortMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongShortMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongShortMapFactoryImpl implements ImmutableLongShortMapFactory
{
    public ImmutableLongShortMap empty()
    {
        return ImmutableLongShortEmptyMap.INSTANCE;
    }

    public ImmutableLongShortMap of()
    {
        return this.empty();
    }

    public ImmutableLongShortMap with()
    {
        return this.empty();
    }

    public ImmutableLongShortMap of(long key, short value)
    {
        return this.with(key, value);
    }

    public ImmutableLongShortMap with(long key, short value)
    {
        return new ImmutableLongShortSingletonMap(key, value);
    }

    public ImmutableLongShortMap ofAll(LongShortMap map)
    {
        return this.withAll(map);
    }

    public ImmutableLongShortMap withAll(LongShortMap map)
    {
        if (map instanceof ImmutableLongShortMap)
        {
            return (ImmutableLongShortMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            long key = map.keysView().longIterator().next();
            return new ImmutableLongShortSingletonMap(key, map.get(key));
        }
        return new ImmutableLongShortHashMap(map);
    }
}
