/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.lazy.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToByteFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToCharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToIntFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToLongFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.block.factory.primitive.DoublePredicates;
import org.eclipse.collections.impl.factory.primitive.DoubleSets;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.utility.internal.primitive.DoubleIterableIterate;
import org.eclipse.collections.impl.utility.primitive.LazyDoubleIterate;

import java.util.NoSuchElementException;

/**
 * This file was automatically generated from template file abstractLazyPrimitiveIterable.stg.
 *
 * @since 5.0
 */
public abstract class AbstractLazyDoubleIterable implements LazyDoubleIterable
{
    public void forEach(DoubleProcedure procedure)
    {
        this.each(procedure);
    }

    public int size()
    {
        return this.count(DoublePredicates.alwaysTrue());
    }

    @Override
    public String toString()
    {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty()
    {
        return DoubleIterableIterate.isEmpty(this);
    }

    public boolean notEmpty()
    {
        return DoubleIterableIterate.notEmpty(this);
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        DoubleIterableIterate.appendString(this, appendable, start, separator, end);
    }

    public boolean contains(double value)
    {
        return this.anySatisfy(DoublePredicates.equal(value));
    }

    public boolean containsAll(double... source)
    {
        return this.containsAll(DoubleSets.immutable.of(source));
    }

    public boolean containsAll(DoubleIterable source)
    {
        return source.allSatisfy((double value) -> AbstractLazyDoubleIterable.this.contains(value));
    }

    public LazyDoubleIterable select(DoublePredicate predicate)
    {
        return LazyDoubleIterate.select(this, predicate);
    }

    public LazyDoubleIterable reject(DoublePredicate predicate)
    {
        return LazyDoubleIterate.select(this, DoublePredicates.not(predicate));
    }

    public <V> LazyIterable<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return LazyDoubleIterate.collect(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyBooleanIterable collectBoolean(DoubleToBooleanFunction function)
    {
        return new CollectDoubleToBooleanIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyByteIterable collectByte(DoubleToByteFunction function)
    {
        return new CollectDoubleToByteIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyCharIterable collectChar(DoubleToCharFunction function)
    {
        return new CollectDoubleToCharIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyShortIterable collectShort(DoubleToShortFunction function)
    {
        return new CollectDoubleToShortIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyIntIterable collectInt(DoubleToIntFunction function)
    {
        return new CollectDoubleToIntIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyFloatIterable collectFloat(DoubleToFloatFunction function)
    {
        return new CollectDoubleToFloatIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyLongIterable collectLong(DoubleToLongFunction function)
    {
        return new CollectDoubleToLongIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyDoubleIterable collectDouble(DoubleToDoubleFunction function)
    {
        return new CollectDoubleToDoubleIterable(this, function);
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return DoubleIterableIterate.detectIfNone(this, predicate, ifNone);
    }

    public int count(DoublePredicate predicate)
    {
        return DoubleIterableIterate.count(this, predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return DoubleIterableIterate.anySatisfy(this, predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return DoubleIterableIterate.allSatisfy(this, predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return DoubleIterableIterate.noneSatisfy(this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return DoubleIterableIterate.injectInto(this, injectedValue, function);
    }

    public double[] toArray()
    {
        return this.toList().toArray();
    }

    public MutableDoubleList toList()
    {
        final MutableDoubleList list = new DoubleArrayList();
        this.forEach(list::add);
        return list;
    }

    public MutableDoubleSet toSet()
    {
        final MutableDoubleSet set = new DoubleHashSet();
        this.forEach(set::add);
        return set;
    }

    public MutableDoubleBag toBag()
    {
        final MutableDoubleBag bag = new DoubleHashBag();
        this.forEach(bag::add);
        return bag;
    }

    public double sum()
    {
        DoubleSumProcedure procedure = new DoubleSumProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public double max()
    {
        if (this.isEmpty())
        {
            throw new NoSuchElementException();
        }
        DoubleMaxProcedure procedure = new DoubleMaxProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public double maxIfEmpty(double ifEmpty)
    {
        if (this.isEmpty())
        {
            return ifEmpty;
        }
        return this.max();
    }

    public double min()
    {
        if (this.isEmpty())
        {
            throw new NoSuchElementException();
        }
        DoubleMinProcedure procedure = new DoubleMinProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public double minIfEmpty(double ifEmpty)
    {
        if (this.isEmpty())
        {
            return ifEmpty;
        }
        return this.min();
    }

    public double average()
    {
        if (this.isEmpty())
        {
            throw new ArithmeticException();
        }
        return (double) this.sum() / (double) this.size();
    }

    public double median()
    {
        if (this.isEmpty())
        {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0)
        {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return ((double) first + (double) second) / 2.0;
        }
        return (double) sortedArray[middleIndex];
    }

    public double[] toSortedArray()
    {
        return this.toSortedList().toArray();
    }

    public MutableDoubleList toSortedList()
    {
        return DoubleArrayList.newList(this).sortThis();
    }

    private static final class DoubleMaxProcedure implements DoubleProcedure
    {
        private boolean visitedOnce;
        private double max;

        public void value(double each)
        {
            if (this.visitedOnce)
            {
                if (Double.compare(this.max, each) < 0)
                {
                    this.max = each;
                }
            }
            else
            {
                this.max = each;
                this.visitedOnce = true;
            }
        }

        public double getValue()
        {
            return this.max;
        }
    }

    private static final class DoubleMinProcedure implements DoubleProcedure
    {
        private boolean visitedOnce;
        private double min;

        public void value(double each)
        {
            if (this.visitedOnce)
            {
                if (Double.compare(each, this.min) < 0)
                {
                    this.min = each;
                }
            }
            else
            {
                this.min = each;
                this.visitedOnce = true;
            }
        }

        public double getValue()
        {
            return this.min;
        }
    }

    private static final class DoubleSumProcedure implements DoubleProcedure
    {
        private double sum = 0.0;
        private double compensation = 0.0;

        public void value(double each)
        {
            double adjustedValue = each - this.compensation;
            double nextSum = this.sum + adjustedValue;
            this.compensation = nextSum - this.sum - adjustedValue;
            this.sum = nextSum;
        }

        public double getValue()
        {
            return this.sum;
        }
    }


    public LazyDoubleIterable asLazy()
    {
        return this;
    }
}
