/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.factory.primitive;

import org.eclipse.collections.api.factory.set.primitive.ImmutableIntSetFactory;
import org.eclipse.collections.api.factory.set.primitive.MutableIntSetFactory;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableIntSetFactoryImpl;
import org.eclipse.collections.impl.set.mutable.primitive.MutableIntSetFactoryImpl;

/**
 * IntSets is a static utility for creating {@link ImmutableIntSetFactory}.
 * This file was automatically generated from template file primitiveSets.stg.
 *
 * @since 3.2.
 */
@SuppressWarnings("ConstantNamingConvention")
public final class IntSets
{
    public static final ImmutableIntSetFactory immutable = new ImmutableIntSetFactoryImpl();
    public static final MutableIntSetFactory mutable = new MutableIntSetFactoryImpl();

    private IntSets()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
