/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.set.MutableSet;

/**
 * This file was automatically generated from template file mutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface MutableIntSet extends MutableIntCollection, IntSet
{
    MutableIntSet select(IntPredicate predicate);

    MutableIntSet reject(IntPredicate predicate);

    <V> MutableSet<V> collect(IntToObjectFunction<? extends V> function);

    MutableIntSet with(int element);

    MutableIntSet without(int element);

    MutableIntSet withAll(IntIterable elements);

    MutableIntSet withoutAll(IntIterable elements);

    MutableIntSet asUnmodifiable();

    MutableIntSet asSynchronized();

    /**
     * Returns a frozen copy of this set. A frozen copy is the same thing as an immutable copy without safe-publish guarantees.
     */
    IntSet freeze();

    /**
     * Returns an immutable copy of this set.
     */
    ImmutableIntSet toImmutable();
}
