/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network;

import java.util.Collection;
import java.util.Iterator;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.layer.GraphLayer;
import org.simantics.diagram.synchronization.graph.layer.IGraphLayerUtil;
import org.simantics.district.network.CRS;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;

public class DistrictNetworkUtil {
    public static Resource createEdge(WriteGraph graph, Resource composite) throws DatabaseException {
        return DistrictNetworkUtil.createEdge(graph, composite, graph.getPossibleObject(composite, DistrictNetworkResource.getInstance((ReadGraph)graph).EdgeDefaultMapping));
    }

    public static Resource createEdge(WriteGraph graph, Resource composite, Resource mapping) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (mapping == null) {
            mapping = graph.getSingleObject(composite, DN.EdgeDefaultMapping);
        }
        Resource edge = graph.newResource();
        graph.claim(edge, L0.InstanceOf, DN.Edge);
        graph.claim(edge, DN.HasMapping, mapping);
        OrderedSetUtils.addFirst((WriteGraph)graph, (Resource)composite, (Resource)edge);
        graph.claim(composite, L0.ConsistsOf, L0.PartOf, edge);
        DistrictNetworkUtil.claimFreshElementName(graph, composite, edge);
        return edge;
    }

    public static Resource createVertex(WriteGraph graph, Resource composite, double[] coords) throws DatabaseException {
        Resource defaultVertexMapping = graph.getPossibleObject(composite, DistrictNetworkResource.getInstance((ReadGraph)graph).VertexDefaultMapping);
        return DistrictNetworkUtil.createVertex(graph, composite, coords, defaultVertexMapping);
    }

    public static Resource createVertex(WriteGraph graph, Resource composite, double[] coords, Resource mapping) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource vertex = graph.newResource();
        graph.claim(vertex, L0.InstanceOf, DN.Vertex);
        graph.claimLiteral(vertex, DIA.HasLocation, (Object)coords);
        graph.claim(vertex, DN.HasMapping, mapping);
        OrderedSetUtils.add((WriteGraph)graph, (Resource)composite, (Resource)vertex);
        graph.claim(composite, L0.ConsistsOf, L0.PartOf, vertex);
        DistrictNetworkUtil.claimFreshElementName(graph, composite, vertex);
        for (Resource layer : graph.getObjects(composite, DiagramResource.getInstance((ReadGraph)graph).HasLayer)) {
            IGraphLayerUtil layerUtil = (IGraphLayerUtil)graph.adapt(graph.getSingleObject(layer, Layer0.getInstance((ReadGraph)graph).InstanceOf), IGraphLayerUtil.class);
            GraphLayer gl = layerUtil.loadLayer((ReadGraph)graph, layer);
            gl.forEachTag(tag -> DiagramGraphUtil.tag((WriteGraph)graph, (Resource)vertex, (Resource)tag, (boolean)true));
        }
        return vertex;
    }

    public static Resource joinVertices(WriteGraph graph, Collection<Resource> vertices) throws DatabaseException {
        if (vertices.isEmpty()) {
            throw new IllegalArgumentException("vertices-collection should not be empty for joining vertices!");
        }
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Iterator<Resource> verticeIterator = vertices.iterator();
        Resource master = verticeIterator.next();
        while (verticeIterator.hasNext()) {
            Resource slave = verticeIterator.next();
            Resource composite = graph.getSingleObject(slave, Layer0.getInstance((ReadGraph)graph).PartOf);
            Collection startVertexEdges = graph.getObjects(slave, DN.HasStartVertex_Inverse);
            for (Resource startVertexEdge : startVertexEdges) {
                graph.deny(startVertexEdge, DN.HasStartVertex);
                graph.claim(startVertexEdge, DN.HasStartVertex, master);
            }
            Collection endVertexEdges = graph.getObjects(slave, DN.HasEndVertex_Inverse);
            for (Resource endVertexEdge : endVertexEdges) {
                graph.deny(endVertexEdge, DN.HasEndVertex);
                graph.claim(endVertexEdge, DN.HasEndVertex, master);
            }
            OrderedSetUtils.remove((WriteGraph)graph, (Resource)composite, (Resource)slave);
            graph.deny(composite, Layer0.getInstance((ReadGraph)graph).ConsistsOf, slave);
        }
        return master;
    }

    public static double calculateDistance(ReadGraph graph, Resource startVertex, Resource endVertex) throws DatabaseException {
        Resource endComposite;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource startComposite = graph.getSingleObject(startVertex, L0.PartOf);
        if (!startComposite.equalsResource(endComposite = graph.getSingleObject(endVertex, L0.PartOf))) {
            throw new DatabaseException("Can not calculate distance between vertices on different composites! " + startVertex + " -> " + endVertex);
        }
        Resource crs = graph.getSingleObject(startComposite, DistrictNetworkResource.getInstance((ReadGraph)graph).HasSpatialRefSystem);
        CRS crsClass = (CRS)graph.adapt(crs, CRS.class);
        double[] startCoords = (double[])graph.getRelatedValue2(startVertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
        double[] endCoords = (double[])graph.getRelatedValue2(endVertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
        return crsClass.calculateDistance(startCoords, endCoords);
    }

    public static final String claimFreshElementName(WriteGraph graph, Resource diagram, Resource element) throws DatabaseException {
        Long l;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String namePrefix = (String)graph.getPossibleRelatedValue2(diagram, Layer0X.getInstance((ReadGraph)graph).HasGeneratedNamePrefix);
        if (namePrefix == null) {
            namePrefix = "";
        }
        if ((l = (Long)graph.getPossibleRelatedValue(diagram, DIA.HasModCount, (Binding)Bindings.LONG)) == null) {
            l = 0L;
        }
        String name = String.valueOf(namePrefix) + l.toString();
        graph.claimLiteral(element, L0.HasName, (Object)name, (Binding)Bindings.STRING);
        l = l + 1L;
        graph.claimLiteral(diagram, DIA.HasModCount, (Object)l, (Binding)Bindings.LONG);
        return name;
    }
}

