/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.simantics.district.network.ModelledCRS;
import org.simantics.district.network.ui.DistrictNetworkEdge;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class DistrictNetworkEdgeNode
extends G2DNode {
    private static final long serialVersionUID = 8049769475036519806L;
    private static final Stroke SELECTION_STROKE = new BasicStroke(1.0f, 0, 0);
    private static final Color SELECTION_COLOR = new Color(255, 0, 255, 96);
    private DistrictNetworkEdge edge;
    private Rectangle2D bounds;
    private static final Stroke STROKE = new BasicStroke(4.0f, 1, 1);
    private boolean scaleStroke = true;
    private Color color;

    public void init() {
    }

    public void render(Graphics2D g2d) {
        AffineTransform ot = null;
        AffineTransform t = this.getTransform();
        if (t != null && !t.isIdentity()) {
            ot = g2d.getTransform();
            g2d.transform(this.getTransform());
        }
        Object aaHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g2d.getColor();
        BasicStroke oldStroke = (BasicStroke)g2d.getStroke();
        g2d.setColor(this.color);
        if (STROKE != null) {
            if (this.scaleStroke && STROKE instanceof BasicStroke) {
                BasicStroke bs = GeometryUtils.scaleStroke((Stroke)STROKE, (float)((float)(1.0 / GeometryUtils.getScale((AffineTransform)g2d.getTransform()))));
                g2d.setStroke(bs);
            } else {
                g2d.setStroke(STROKE);
            }
        }
        g2d.draw(DistrictNetworkEdgeNode.calculatePath(this.edge));
        g2d.setStroke(oldStroke);
        g2d.setColor(oldColor);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    public static Path2D calculatePath(DistrictNetworkEdge edge) {
        double startX = ModelledCRS.longitudeToX((double)edge.getStartPoint().getX());
        double startY = ModelledCRS.latitudeToY((double)edge.getStartPoint().getY());
        double endX = ModelledCRS.longitudeToX((double)edge.getEndPoint().getX());
        double endY = ModelledCRS.latitudeToY((double)edge.getEndPoint().getY());
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(startX, startY);
        ((Path2D)path).lineTo(endX, endY);
        return path;
    }

    private boolean isSelected() {
        return NodeUtil.isSelected((INode)this, (int)1);
    }

    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    private void updateBounds() {
        Rectangle2D oldBounds = this.bounds;
        if (oldBounds == null) {
            oldBounds = new Rectangle2D.Double();
        }
        this.bounds = this.calculateBounds(oldBounds);
    }

    private Rectangle2D calculateBounds(Rectangle2D rect) {
        return DistrictNetworkEdgeNode.calculatePath(this.edge).getBounds2D();
    }

    public void setDNEdge(DistrictNetworkEdge edge) {
        this.edge = edge;
        this.updateBounds();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }
}

