/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.adapters;

import java.awt.geom.AffineTransform;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerManager;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.adapters.DistrictNetworkAdditionalColor;
import org.simantics.district.network.ui.adapters.DistrictNetworkVertex;
import org.simantics.district.network.ui.adapters.DistrictNetworkVertexElement;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.maps.MapScalingTransform;

public class DistrictNetworkVertexElementFactory
extends SyncElementFactory {
    public static final ElementClass CLASS = DistrictNetworkVertexElement.CLASS;
    private DistrictNetworkResource DN;
    private DiagramResource DIA;

    public DistrictNetworkVertexElementFactory(ReadGraph graph) {
        this.DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
    }

    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, (Object)CLASS.newClassWith(false, new ElementHandler[]{new StaticObjectAdapter((Object)elementType)}));
    }

    protected Resource getElementClassBaseType(AsyncReadGraph graph) {
        return this.DN.Vertex;
    }

    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource vertexResource, IElement element) throws DatabaseException {
        double[] coords = (double[])graph.getRelatedValue(vertexResource, this.DIA.HasLocation);
        DistrictNetworkVertex vertex = new DistrictNetworkVertex(coords);
        Resource mapping = graph.getSingleObject(vertexResource, DistrictNetworkResource.getInstance((ReadGraph)graph).HasMapping);
        element.setHint(DistrictNetworkAdditionalColor.KEY_DN_MAPPING_RESOURCE, (Object)mapping);
        element.setHint(DistrictNetworkVertexElement.KEY_DN_VERTEX, (Object)vertex);
        ElementUtils.setTransform((IElement)element, (AffineTransform)MapScalingTransform.INSTANCE);
        IModifiableSynchronizationContext context = (IModifiableSynchronizationContext)diagram.getHint(SynchronizationHints.CONTEXT);
        GraphLayerManager layerManager = (GraphLayerManager)context.get(GraphSynchronizationHints.GRAPH_LAYER_MANAGER);
        ILayersEditor layersEditor = (ILayersEditor)diagram.getHint(DiagramHints.KEY_LAYERS_EDITOR);
        layerManager.loadLayersForElement(graph, layersEditor, element, vertexResource);
    }
}

