/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.sg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.GridUtils;

public class MapScaleNode
extends G2DNode {
    private static final long serialVersionUID = -2738682328944298290L;
    private static final Color GRAY = new Color(100, 100, 100);
    protected Boolean enabled = true;
    protected double gridSize = 1.0;
    private static final transient int MAX_DIGITS = 0;
    private static final transient double EPSILON = 0.01;
    private static final transient double TRIM_THRESHOLD_MAX_VALUE = Math.pow(10.0, 2.0);
    private static final transient String[] SI_UNIT_LARGE_PREFIXES = new String[]{"m", "km"};
    private static final transient double[] SCALE_VALUES = new double[]{2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0, 200000.0, 500000.0, 1000000.0, 2000000.0, 5.0E7};
    GeodeticCalculator calculator;
    CoordinateReferenceSystem EPSG4326;

    public void render(Graphics2D g) {
        if (!this.enabled.booleanValue()) {
            return;
        }
        AffineTransform ot = g.getTransform();
        g.transform(this.transform);
        AffineTransform tr = g.getTransform();
        double scaleX = Math.abs(tr.getScaleX());
        double scaleY = Math.abs(tr.getScaleY());
        if (scaleX <= 0.0 || scaleY <= 0.0) {
            return;
        }
        double offsetX = tr.getTranslateX();
        double offsetY = tr.getTranslateY();
        g.setTransform(new AffineTransform());
        Font rulerFont = new Font("Tahoma", 0, 9);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(new Color(0.9f, 0.9f, 0.9f, 0.75f));
        Rectangle bounds = g.getClipBounds();
        if (bounds == null) {
            return;
        }
        double previousText = -100.0;
        double minY = bounds.getMaxY() - 30.0;
        double scaleRight = bounds.getMaxX() - 30.0;
        double meterPerPixel = this.getMeterPerPixel(scaleRight - offsetX, minY - offsetY, scaleX, scaleY);
        double pixels = 0.0;
        double value = 0.0;
        int i = 0;
        while (i < SCALE_VALUES.length) {
            value = SCALE_VALUES[i];
            pixels = value / meterPerPixel;
            if (pixels > 100.0) break;
            ++i;
        }
        double newScaleLeft = scaleRight - pixels;
        g.setComposite(AlphaComposite.getInstance(3, 0.8f));
        Rectangle2D.Double vertical = new Rectangle2D.Double(newScaleLeft, bounds.getMaxY() - 30.0, pixels, 20.0);
        g.fill(vertical);
        g.setColor(GRAY);
        g.setFont(rulerFont);
        double stepX = 50.0;
        stepX = GridUtils.limitedEvenGridSpacing((double)stepX, (double)scaleX, (double)100.0, (double)this.gridSize, (boolean)true);
        while (stepX * scaleX < 50.0) {
            stepX *= 2.0;
        }
        stepX *= scaleX;
        double gap = scaleRight - newScaleLeft;
        stepX = gap / 2.0 - 1.0E-5;
        double label = 0.0;
        double x = newScaleLeft;
        while (x < scaleRight) {
            String str = MapScaleNode.formatValue(label * meterPerPixel);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D r = fm.getStringBounds(str, g);
            if (x - r.getWidth() / 2.0 > previousText) {
                g.setColor(Color.BLACK);
                g.drawString(str, (int)(x - r.getWidth() / 2.0), (int)(minY + 1.0 + r.getHeight()));
                previousText = x + r.getWidth() / 2.0 + stepX / 4.0;
            }
            g.setColor(GRAY);
            g.drawLine((int)x, (int)minY + 12, (int)x, (int)minY + 19);
            if (x + 0.1 < scaleRight && stepX / 5.0 > 2.0) {
                double x2 = x + stepX / 5.0;
                while (x2 < x + stepX) {
                    if (x2 > 20.0) {
                        g.drawLine((int)x2, (int)minY + 15, (int)x2, (int)minY + 19);
                    }
                    x2 += stepX / 5.0;
                }
                x2 = x + stepX / 10.0;
                while (x2 < x + stepX) {
                    if (x2 > 20.0) {
                        g.drawLine((int)x2, (int)minY + 17, (int)x2, (int)minY + 19);
                    }
                    x2 += stepX / 5.0;
                }
            }
            label += stepX;
            x += stepX;
        }
        g.setTransform(ot);
    }

    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    public static String formatValue(double value) {
        int magnitude = (int)Math.round(Math.log10(value));
        int allowedDecimals = 0;
        if ((allowedDecimals -= Math.abs(magnitude)) < 0) {
            allowedDecimals = 0;
        }
        String valueStr = String.format(Locale.US, "%." + allowedDecimals + "f", value);
        if (allowedDecimals > 0) {
            int dotIndex;
            int trunc = valueStr.length() - 1;
            while (trunc > 0) {
                char ch = valueStr.charAt(trunc);
                if (ch == '.') {
                    valueStr = valueStr.substring(0, trunc);
                    break;
                }
                if (valueStr.charAt(trunc) != '0') {
                    valueStr = valueStr.substring(0, trunc + 1);
                    break;
                }
                --trunc;
            }
            if (Math.abs(value) + 0.01 > TRIM_THRESHOLD_MAX_VALUE && (dotIndex = valueStr.lastIndexOf(46)) > -1) {
                valueStr = valueStr.substring(0, dotIndex);
            }
        }
        if (valueStr.equals("-0")) {
            valueStr = "0";
        }
        return valueStr;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void init() {
        try {
            this.EPSG4326 = CRS.decode((String)"EPSG:4326");
            this.calculator = new GeodeticCalculator(this.EPSG4326);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        super.init();
    }

    public Point2D scaleLeftmostPoint(double startLon, double startLat, double distance, double azimuth) {
        GeodeticCalculator calculator = new GeodeticCalculator();
        calculator.setStartingGeographicPoint(startLon, startLat);
        calculator.setDirection(azimuth, distance);
        return calculator.getDestinationGeographicPoint();
    }

    public double getMeterPerPixel(double screenX, double screenY, double scaleX, double scaleY) {
        double startLon = screenX / scaleX;
        double val = screenY / scaleY;
        double startLat = val = Math.toDegrees(Math.atan(Math.sinh(Math.toRadians(val))));
        double endLon = (screenX + 1.0) / scaleX;
        double endLat = val;
        this.calculator.setStartingGeographicPoint(startLon, startLat);
        this.calculator.setDestinationGeographicPoint(endLon, endLat);
        double distance = this.calculator.getOrthodromicDistance();
        return distance;
    }
}

