/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.imports.ui;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.simantics.db.Resource;
import org.simantics.district.imports.DistrictImportUtils;

public class CSVImportModel {
    private Resource targetDiagram;
    private Path source;
    private char delimiter;
    private boolean readFirstAsHeader = true;
    private Map<String, Character> delimiters;
    private int xCoordIndex = -1;
    private int yCoordIndex = -1;
    private int zCoordIndex = -1;
    private int startXCoordIndex = -1;
    private int startYCoordIndex = -1;
    private int startZCoordIndex = -1;
    private int endXCoordIndex = -1;
    private int endYCoordIndex = -1;
    private int endZCoordIndex = -1;
    private int componentMappingIndex = -1;
    private Map<String, Resource> componentMappings = new HashMap<String, Resource>();
    private boolean isVertexImport;
    private String sourceCRS;
    private int supplytempIndex = -1;
    private int supplypressureIndex = -1;
    private int diameterIndex = -1;
    private int outerDiamterIndex = -1;
    private int nominalMassFlowIndex = -1;
    private int returnTempIndex = -1;
    private int returnPressureIndex = -1;
    private int deltaPressureIndex = -1;
    private int deltaTemperatureIndex = -1;
    private int heatPowerIndex = -1;
    private int nominalHeadMIndex = -1;
    private int nominalHeadBIndex = -1;
    private int nominalFlowIndex = -1;
    private int maximumHeadMIndex = -1;
    private int heatLoadDsIndex = -1;
    private int massFlowIndex = -1;
    private int volFlowIndex = -1;
    private int velocityIndex = -1;
    private int flowAreaIndex = -1;
    private int nominalPressureLossIndex = -1;
    private int edgeFlowAreaIndex = -1;
    private int kReturnIndex = -1;
    private int kSupplyIndex = -1;
    private int tGroundIndex = -1;
    private int idIndex = -1;
    private double edgePadding = 1.0E-4;
    private int valvePositionIndx = -1;

    public CSVImportModel() {
        this.delimiters = DistrictImportUtils.getSupportedCSVDelimiterFormats();
    }

    public void setSource(Path source) {
        this.source = source;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void setReadFirstAsHeader(boolean read) {
        this.readFirstAsHeader = read;
    }

    public Path getSource() {
        return this.source;
    }

    public List<CSVRecord> getRows(int amount) throws IOException {
        if (this.source != null) {
            return DistrictImportUtils.readRows((Path)this.source, (char)this.delimiter, (int)amount);
        }
        return Collections.emptyList();
    }

    public Map<DistrictImportUtils.CSVHeader, List<String>> getHeaderAndRows(int amount) throws IOException {
        if (this.source != null) {
            return DistrictImportUtils.readCSVHeaderAndRows((Path)this.source, (char)this.delimiter, (boolean)this.readFirstAsHeader, (int)amount);
        }
        return Collections.emptyMap();
    }

    public Map<String, Integer> getHeader() throws IOException {
        Map header = null;
        if (this.source != null) {
            header = DistrictImportUtils.readCSVHeader((Path)this.source, (char)this.delimiter, (boolean)this.readFirstAsHeader);
        }
        if (header == null) {
            header = Collections.emptyMap();
        }
        return header;
    }

    public boolean getReadFirstAsHeader() {
        return this.readFirstAsHeader;
    }

    public String[] getDelimiterFormats() {
        return this.delimiters.keySet().toArray(new String[this.delimiters.size()]);
    }

    public void setDelimiterByLabel(String item) {
        this.setDelimiter(this.delimiters.get(item).charValue());
    }

    public List<Map<String, String>> readRows(int amount) throws IOException {
        if (this.source != null) {
            return DistrictImportUtils.readRows((Path)this.source, (char)this.delimiter, (boolean)this.readFirstAsHeader, (int)amount);
        }
        return Collections.emptyList();
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public int getXCoordIndex() {
        return this.xCoordIndex;
    }

    public void setXCoordIndex(int xCoordIndex) {
        this.xCoordIndex = xCoordIndex;
    }

    public int getYCoordIndex() {
        return this.yCoordIndex;
    }

    public void setYCoordIndex(int yCoordIndex) {
        this.yCoordIndex = yCoordIndex;
    }

    public int getZCoordIndex() {
        return this.zCoordIndex;
    }

    public void setZCoordIndex(int zCoordIndex) {
        this.zCoordIndex = zCoordIndex;
    }

    public int getComponentMappingIndex() {
        return this.componentMappingIndex;
    }

    public void setComponentMappingIndex(int componentMappingIndex) {
        this.componentMappingIndex = componentMappingIndex;
    }

    public void setParentDiagram(Resource diagram) {
        this.targetDiagram = diagram;
    }

    public Resource getParentDiagram() {
        return this.targetDiagram;
    }

    public void setComponentMappings(String value, Resource resource) {
        this.componentMappings.put(value, resource);
    }

    public Map<String, Resource> getComponentMappings() {
        return this.componentMappings;
    }

    public boolean isVertexImport() {
        return this.isVertexImport;
    }

    public void setVertexImport(boolean isVertexImport) {
        this.isVertexImport = isVertexImport;
    }

    public void setStartXCoordIndex(int parseInt) {
        this.startXCoordIndex = parseInt;
    }

    public int getStartXCoordIndex() {
        return this.startXCoordIndex;
    }

    public void setStartYCoordIndex(int parseInt) {
        this.startYCoordIndex = parseInt;
    }

    public int getStartYCoordIndex() {
        return this.startYCoordIndex;
    }

    public void setStartZCoordIndex(int parseInt) {
        this.startZCoordIndex = parseInt;
    }

    public int getStartZCoordIndex() {
        return this.startZCoordIndex;
    }

    public void setEndXCoordIndex(int parseInt) {
        this.endXCoordIndex = parseInt;
    }

    public int getEndXCoordIndex() {
        return this.endXCoordIndex;
    }

    public void setEndYCoordIndex(int parseInt) {
        this.endYCoordIndex = parseInt;
    }

    public int getEndYCoordIndex() {
        return this.endYCoordIndex;
    }

    public void setEndZCoordIndex(int parseInt) {
        this.endZCoordIndex = parseInt;
    }

    public int getEndZCoordIndex() {
        return this.endZCoordIndex;
    }

    public void setSourceCRS(String crs) {
        this.sourceCRS = crs;
    }

    public String getSourceCRS() {
        return this.sourceCRS;
    }

    public void setSupplyTempIndex(int supplyTempIndex) {
        this.supplytempIndex = supplyTempIndex;
    }

    public int getSupplyTempIndex() {
        return this.supplytempIndex;
    }

    public void setSupplyPressureIndex(int supplyPressureIndex) {
        this.supplypressureIndex = supplyPressureIndex;
    }

    public int getSupplyPressureIndex() {
        return this.supplypressureIndex;
    }

    public void setReturnTempIndex(int returnTempIndex) {
        this.returnTempIndex = returnTempIndex;
    }

    public int getReturnTempIndex() {
        return this.returnTempIndex;
    }

    public void setReturnPressureIndex(int returnPressureIndex) {
        this.returnPressureIndex = returnPressureIndex;
    }

    public int getReturnPressureIndex() {
        return this.returnPressureIndex;
    }

    public void setDiameterIndex(int parseInt) {
        this.diameterIndex = parseInt;
    }

    public int getDiameterIndex() {
        return this.diameterIndex;
    }

    public void setOuterDiameterIndex(int parseInt) {
        this.outerDiamterIndex = parseInt;
    }

    public int getOuterDiamterIndex() {
        return this.outerDiamterIndex;
    }

    public void setNominalMassFlowIndex(int parseInt) {
        this.nominalMassFlowIndex = parseInt;
    }

    public int getNominalMassFlowIndex() {
        return this.nominalMassFlowIndex;
    }

    public void setDeltaPressureIndex(int parseInt) {
        this.deltaPressureIndex = parseInt;
    }

    public int getDeltaPressureIndex() {
        return this.deltaPressureIndex;
    }

    public void setDeltaTemperatureIndex(int parseInt) {
        this.deltaTemperatureIndex = parseInt;
    }

    public int getDeltaTemperatureIndex() {
        return this.deltaTemperatureIndex;
    }

    public void setHeatPowerIndex(int parseInt) {
        this.heatPowerIndex = parseInt;
    }

    public int getHeatPowerIndex() {
        return this.heatPowerIndex;
    }

    public void setNominalHeadMIndex(int parseInt) {
        this.nominalHeadMIndex = parseInt;
    }

    public int getNominalHeadMIndex() {
        return this.nominalHeadMIndex;
    }

    public void setNominalHeadBIndex(int parseInt) {
        this.nominalHeadBIndex = parseInt;
    }

    public int getNominalHeadBIndex() {
        return this.nominalHeadBIndex;
    }

    public void setNominalFlowIndex(int parseInt) {
        this.nominalFlowIndex = parseInt;
    }

    public int getNominalFlowIndex() {
        return this.nominalFlowIndex;
    }

    public void setMaximumHeadMIndex(int parseInt) {
        this.maximumHeadMIndex = parseInt;
    }

    public int getMaximumHeadMIndex() {
        return this.maximumHeadMIndex;
    }

    public void setHeatLoadDsIndex(int parseInt) {
        this.heatLoadDsIndex = parseInt;
    }

    public int getHeatLoadDsIndex() {
        return this.heatLoadDsIndex;
    }

    public void setMassFlowIndex(int parseInt) {
        this.massFlowIndex = parseInt;
    }

    public int getMassFlowIndex() {
        return this.massFlowIndex;
    }

    public void setVolFlowIndex(int parseInt) {
        this.volFlowIndex = parseInt;
    }

    public int getVolFlowIndex() {
        return this.volFlowIndex;
    }

    public void setVelocityIndex(int parseInt) {
        this.velocityIndex = parseInt;
    }

    public int getVelocityIndex() {
        return this.velocityIndex;
    }

    public void setFlowAreaIndex(int parseInt) {
        this.flowAreaIndex = parseInt;
    }

    public int getFlowAreaIndex() {
        return this.flowAreaIndex;
    }

    public void setNominalPressureLossIndex(int parseInt) {
        this.nominalPressureLossIndex = parseInt;
    }

    public int getNominalPressureLossIndex() {
        return this.nominalPressureLossIndex;
    }

    public void setEdgeFlowAreaIndex(int parseInt) {
        this.edgeFlowAreaIndex = parseInt;
    }

    public int getEdgeFlowAreaIndex() {
        return this.edgeFlowAreaIndex;
    }

    public void setKReturnIndex(int parseInt) {
        this.kReturnIndex = parseInt;
    }

    public int getkReturnIndex() {
        return this.kReturnIndex;
    }

    public void setKSupplyIndex(int parseInt) {
        this.kSupplyIndex = parseInt;
    }

    public int getkSupplyIndex() {
        return this.kSupplyIndex;
    }

    public void setTGroundIndex(int parseInt) {
        this.tGroundIndex = parseInt;
    }

    public int gettGroundIndex() {
        return this.tGroundIndex;
    }

    public int getIdIndex() {
        return this.idIndex;
    }

    public void setIdIndex(int idIndex) {
        this.idIndex = idIndex;
    }

    public void setEdgePapping(double edgePadding) {
        this.edgePadding = edgePadding;
    }

    public double getEdgePadding() {
        return this.edgePadding;
    }

    public void setValvePositionIndex(int valvePositionIndx) {
        this.valvePositionIndx = valvePositionIndx;
    }

    public int getValvePositionIndx() {
        return this.valvePositionIndx;
    }
}

