package org.simantics.ui.workspace.tracker.internal.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.simantics.ui.workspace.tracker.IWorkspaceSizeTrackerConstants;
import org.simantics.ui.workspace.tracker.internal.Activator;
import org.simantics.ui.workspace.tracker.internal.contributions.WorkspaceSizeTrackerContribution;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public class WorkspaceSizeTrackingPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	private BooleanFieldEditor fShowSizeMonitor;
	private IntegerFieldEditor fUpdateInterval;
	private BooleanFieldEditor fHighlightLowSpace;
	private IntegerFieldEditor fLowSpaceThreshold;

	/**
	 * Create the console page.
	 */
	public WorkspaceSizeTrackingPreferencePage() {
		super(GRID);
		setDescription(Messages.WorkspaceSizeTrackingPreferencePage_Workspace_Size_Tracking_Settings);
		setPreferenceStore(Activator.getDefault().getPreferenceStore());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#createControl(Composite)
	 */
	@Override
	public void createControl(Composite parent) {
		super.createControl(parent);
	}

	/**
	 * Create all field editors for this page
	 */
	@Override
	public void createFieldEditors() {
		fShowSizeMonitor = new BooleanFieldEditor(IWorkspaceSizeTrackerConstants.PREF_SHOW_MONITOR, Messages.WorkspaceSizeTrackingPreferencePage_Show_Monitor, SWT.NONE, getFieldEditorParent());
		addField(fShowSizeMonitor);
		fUpdateInterval = new IntegerFieldEditor(IWorkspaceSizeTrackerConstants.PREF_UPDATE_INTERVAL, Messages.WorkspaceSizeTrackingPreferencePage_Update_Interval, getFieldEditorParent());
		fUpdateInterval.setValidRange(100, 10000);
		addField(fUpdateInterval);
		fHighlightLowSpace = new BooleanFieldEditor(IWorkspaceSizeTrackerConstants.PREF_HIGHLIGHT_LOW_SPACE, Messages.WorkspaceSizeTrackingPreferencePage_Highlight_Low_Space, SWT.NONE, getFieldEditorParent());
		addField(fHighlightLowSpace);
		fLowSpaceThreshold = new IntegerFieldEditor(IWorkspaceSizeTrackerConstants.PREF_LOW_SPACE_THRESHOLD, Messages.WorkspaceSizeTrackingPreferencePage_Low_Space_Threshold, getFieldEditorParent());
		fLowSpaceThreshold.setValidRange(100, 100000000);
		addField(fLowSpaceThreshold);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	@Override
	public void init(IWorkbench workbench) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditorPreferencePage#performOk()
	 */
	@Override
	public boolean performOk() {
		boolean show = fShowSizeMonitor.getBooleanValue();
		WorkspaceSizeTrackerContribution.showTracker(show);
		return super.performOk();
	}

}
