package org.simantics.spreadsheet.fileimport;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.fileimport.SimanticsResourceFileImport;
import org.simantics.spreadsheet.graph.ExcelImport;

public class ExcelFileImport extends SimanticsResourceFileImport {

    private static final Map<String, String> ALLOWED_EXTENSIONS = new HashMap<>(2);
    
    static {
        ALLOWED_EXTENSIONS.put("*.xls", "Excel file *.xls");
        ALLOWED_EXTENSIONS.put("*.xlsx", "Excel file *.xlsx");
    }
    
    @Override
    public Optional<Resource> perform(Resource parent, Path file) throws Exception {
        return Optional.ofNullable(ExcelImport.importBookR(parent, file.toFile()));
    }

    @Override
    public Map<String, String> allowedExtensionsWithFilters() {
        return ALLOWED_EXTENSIONS;
    }

    @Override
    public Resource defaultParentResource() {
        return Simantics.getSession().getRootLibrary();
    }

}
