package org.simantics.simulation.export;

import java.util.Collection;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.DiscoverAction;
import org.simantics.export.core.util.ExportQueries;
import org.simantics.modeling.ModelingResources;

/**
 * Discovers experiment results
 *
 * @author toni.kalajainen@semantum.fi
 */
public class DiscoverSubscriptions implements DiscoverAction {

	public Read<Collection<String>> discoverRequest(
			final Collection<String> startLocations) throws ExportException {
		return ExportQueries.instancesOf(startLocations, ModelingResources.URIs.Subscription);			
	}

	@Override
	public Collection<String> discoverContent(ExportContext ctx, Collection<String> startLocations) throws ExportException {		
		try {
			return ctx.session.syncRequest( discoverRequest(startLocations) );
		} catch (DatabaseException e) {
			if ( e.getCause() instanceof ExportException ) throw (ExportException) e.getCause();
			throw new ExportException( e );
		}
	}

}
