/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.data;

import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;

/**
 * A handle to a variable of a {@link Datasource}.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public interface VariableHandle {

	/**
	 * @return key (ID) of the variable
	 */
	String key();

	/**
	 * @return binding for the variable
	 */
	Binding binding();

	/**
	 * @return current value associated with this handle
	 * @throws AccessorException if value cannot be retrieved
	 */
	Object getValue() throws AccessorException;

	/**
	 * Frees any resource related to this handle.
	 */
	void dispose();

}

