/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.data;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import org.simantics.utils.datastructures.ListenerList;

/**
 * @author Toni Kalajainen
 */
public abstract class AbstractDatasource implements Datasource {

    protected ListenerList<DatasourceListener> listeners = new ListenerList<DatasourceListener>(DatasourceListener.class);
    protected Lock readLock, writeLock;

    public AbstractDatasource() {
//        ReentrantReadWriteLock l = new ReentrantReadWriteLock();
//        this.readLock = l.readLock();
//        this.writeLock = l.writeLock();
        this.readLock = this.writeLock = new ReentrantLock();
    }

    @Override
    public void addListener(DatasourceListener listener) {
        listeners.add(listener);
    }

    @Override
    public void removeListener(DatasourceListener listener) {
        listeners.remove(listener);
    }

    protected void notifyStep() {
        for (final DatasourceListener l : listeners.getListeners()) {
            if (l.getExecutor() == null) {
                l.onStep( AbstractDatasource.this );
            } else {
                l.getExecutor().execute(new Runnable() {
                    public void run() {
                        l.onStep(AbstractDatasource.this);
                    }
                });
            }
        }
    }

    @Override
    public Lock readLock() {
        return readLock;
    }

}
