package org.simantics.scl.ui.modulebrowser;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.scl.ui.Activator;

import gnu.trove.map.hash.THashMap;

public class CreateModuleAction {
    public static final String PREFIX = "reference:file:/";
    
    public static final void createModule(Bundle bundle, String packageName, String moduleName) throws IOException {
        String bundleLocation = bundle.getLocation();
        bundleLocation = bundleLocation.substring(PREFIX.length());
        
        Path packagePath = Paths.get(bundleLocation).resolve("scl").resolve(packageName);
        Files.createDirectories(packagePath);
        Path modulePath = packagePath.resolve(moduleName + ".scl");
        if(Files.exists(modulePath))
            return;
        Files.createFile(modulePath);
    }
    
    public static THashMap<String,Bundle> findGoodBundles() {
        BundleContext context = Activator.getInstance().getBundle().getBundleContext();
        THashMap<String,Bundle> result = new THashMap<String,Bundle>();
        for(Bundle bundle : context.getBundles()) {
            String location = bundle.getLocation();
            if(location.endsWith(".jar") || !location.startsWith(PREFIX))
                continue;
            location = location.substring(PREFIX.length());
            Path bundlePath = Paths.get(location);
            if(!Files.isDirectory(bundlePath))
                continue;
            result.put(bundle.getSymbolicName(), bundle);
        }
        return result;
    }
 
    public static String findBestPlugin(THashMap<String,Bundle> bundles, String packageName) {
        for(Bundle bundle : bundles.values()) {
            String location = bundle.getLocation();
            location = location.substring(PREFIX.length());
            Path packagePath = Paths.get(location).resolve("scl").resolve(packageName);
            if(Files.exists(packagePath))
                return bundle.getSymbolicName();
        }
        int p = packageName.lastIndexOf('/');
        if(p == -1)
            return "";
        else
            return findBestPlugin(bundles, packageName.substring(0, p));
    }

    public static int packageMatchLength(Bundle bundle, String packageName) {
        if(bundle.getEntry("scl") == null)
            return 0;
        packageName = "scl/" + packageName;
        while(packageName.length() > 3) {
            if(bundle.getEntry(packageName) != null)
                return packageName.length();
            int p = packageName.lastIndexOf('/');
            packageName = packageName.substring(0, p);
        }
        return 3;
    }
}
