package org.simantics.scl.ui.console;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

/**
 * @author Antti Villberg
 */
public final class Preferences {

    public static final String  COMMAND_HISTORY = "COMMAND_HISTORY";

    private static final String DELIMITER       = "";

    public static String join(Collection<String> s, String delimiter) {
        if (s == null || s.isEmpty()) return "";
        Iterator<String> iter = s.iterator();
        StringBuilder builder = new StringBuilder(iter.next());
        while( iter.hasNext() )
        {
            builder.append(delimiter).append(iter.next());
        }
        return builder.toString();
    }
    
    public static Deque<String> decodePaths(String recentPathsPref) {
        Deque<String> result = new LinkedList<String>();
        for(String s : recentPathsPref.split(DELIMITER)) result.add(s);
        return result;
    }

    public static String encodePaths(Collection<String> recentPaths) {
        return join(recentPaths, DELIMITER);
    }

    public static <T> void removeDuplicates(Iterable<String> iter) {
        // Remove duplicates
        Set<String> dups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Iterator<String> it = iter.iterator(); it.hasNext();) {
            String path = it.next();
            if (!dups.add(path)) {
                it.remove();
            }
        }
    }

}
