/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.predicates;

import java.util.Collection;

import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

public class Negation extends UnaryPredicate {

	IUnaryPredicate predicate;
	
	public Negation(IUnaryPredicate predicate) {
		this.predicate = predicate;
	}

	@Override
	public void add(WriteGraph g, Resource r) throws DatabaseException {
		predicate.remove(g, r);
	}

	@Override
	public Collection<Resource> getResources(ReadGraph g) {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
		return !predicate.has(g, resource);
	}

	@Override
	public void remove(WriteGraph g, Resource r) throws DatabaseException {
		predicate.add(g, r);
	}

	@Override
	public boolean supportsAddition() {
		return predicate.supportsRemoval();
	}

	@Override
	public boolean supportsRemoval() {
		return predicate.supportsAddition();
	}

	@Override
	public boolean supportsUnboundedQuery() {
		return false;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((predicate == null) ? 0 : predicate.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Negation other = (Negation) obj;
		if (predicate == null) {
			if (other.predicate != null)
				return false;
		} else if (!predicate.equals(other.predicate))
			return false;
		return true;
	}
	
}
