/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;

/**
 * This utility class helps in adding, removing and searching of history items.
 * The input and result if convertible with Item[] configuration.
 *  
 * @author toni.kalajainen
 */
public class ItemManager {
	
	Map<String, Bean> items = new TreeMap<String, Bean>();

	public static <Item extends Bean> ItemManager createUnchecked( @SuppressWarnings("unchecked") Item...items ) {
		try {
			return new ItemManager(items);
		} catch (HistoryException e) {
			throw new RuntimeException(e);
		}
	}

	public <Item extends Bean> ItemManager( @SuppressWarnings("unchecked") Item...items ) throws HistoryException
	{
		try {
			for (Item item : items) {
				String id = (String) item.getField("id");
				this.items.put( id, item );
			}
		} catch (BindingException e) {
			throw new HistoryException( e );
		}
	}
	
	public <Item extends Bean> ItemManager( List<Item> items ) throws HistoryException
	{
		try {
			for (Item item : items) {
				String id = (String) item.getField("id");
				this.items.put( id, item );
			}
		} catch (BindingException e) {
			throw new HistoryException( e );
		}
	}
	
	public boolean exists(String id)
	{
		return items.containsKey(id);
	}
	
	public Bean get(String id) 
	{
		return items.get( id );
	}
	
	public Set<String> ids()
	{
		return items.keySet();
	}

	public Collection<Bean> values()
	{
		return items.values();
	}
	
	public Bean[] toArray() 
	{
		return items.values().toArray( new Bean[ items.size() ] );
	}
	
	public String[] toIdArray()
	{
		return items.keySet().toArray( new String[ items.size() ] );
	}
	
	public void add(Bean item) throws BindingException 
	{
		items.put( (String) item.getIdentifier(), item.clone()); 
	}
	
	public Bean remove(String id)
	{
		return items.remove(id);
	}
	
	public void remove(Bean...items)
	{
		for (Bean item : items)
		{
			try {
				this.items.remove( (String) item.getIdentifier() );
			} catch (BindingException e) {
			}
		}
	}
	
	public List<Bean> search(String fieldName1, Object expected1) throws BindingException
	{
		try {
			Binding binding1 = getBinding(expected1);
			List<Bean> result = new ArrayList<Bean>();
			for (Bean item : items.values()) {
				Binding cb1 = item.getFieldBinding(fieldName1);
				Object cv1 = item.getField(fieldName1);
				
				boolean matches1 = 
						(expected1==null && cv1==null) || 
						(cv1!=null && cb1!=null && binding1!=null && expected1!=null &&
						 Bindings.equals(cb1, cv1, binding1, expected1));
				
				if ( matches1 ) result.add(item);				
			}
			return result;
		} catch (BindingConstructionException bce) {
			throw new BindingException(bce);
		}
	}

	public List<Bean> search(String fieldName1, Object expected1, String fieldName2, Object expected2) throws BindingException
	{
		try {
			List<Bean> result = new ArrayList<Bean>();
			Binding binding1 = getBinding(expected1);
			Binding binding2 = getBinding(expected2);
			for (Bean item : items.values()) {
				Binding cb1 = item.getFieldBinding(fieldName1);
				Object cv1 = item.getField(fieldName1);
				boolean matches1 = (expected1==null && cv1==null) || (Bindings.equals(cb1, cv1, binding1, expected1));
				
				Binding cb2 = item.getFieldBinding(fieldName2);
				Object cv2 = item.getField(fieldName2);
				boolean matches2 = (expected2==null && cv2==null) || (Bindings.equals(cb2, cv2, binding2, expected2));

				if ( matches1 && matches2 ) result.add(item);				
			}
			return result;
		} catch (BindingConstructionException bce) {
			throw new BindingException(bce);
		}
	}

	public List<Bean> search(
			String fieldName1, Object expected1,
			String fieldName2, Object expected2,
			String fieldName3, Object expected3)
					throws BindingException
	{
		try {
			List<Bean> result = new ArrayList<Bean>();
			Binding binding1 = getBinding(expected1);
			Binding binding2 = getBinding(expected2);
			Binding binding3 = getBinding(expected3);
			for (Bean item : items.values()) {
				Binding cb1 = item.getFieldBinding(fieldName1);
				Object cv1 = item.getField(fieldName1);
				boolean matches1 = (expected1==null && cv1==null) || (Bindings.equals(cb1, cv1, binding1, expected1));
				
				Binding cb2 = item.getFieldBinding(fieldName2);
				Object cv2 = item.getField(fieldName2);
				boolean matches2 = (expected2==null && cv2==null) || (Bindings.equals(cb2, cv2, binding2, expected2));

				Binding cb3 = item.getFieldBinding(fieldName3);
				Object cv3 = item.getField(fieldName3);
				boolean matches3 = (expected3==null && cv3==null) || (Bindings.equals(cb3, cv3, binding3, expected3));

				if ( matches1 && matches2 && matches3 ) result.add(item);
			}
			return result;
		} catch (BindingConstructionException bce) {
			throw new BindingException(bce);
		}
	}
	
	Binding getBinding(Object data) throws BindingConstructionException {
		if ( data==null ) return null;
		Class<?> clazz = data.getClass();
		if ( Datatype.class.isAssignableFrom(clazz) ) return Bindings.getBinding( Datatype.class );
		return Bindings.getBinding(clazz);
	}

	public List<Bean> search(
			String fieldName1, Object expected1, 
			String fieldName2, Object expected2, 
			String fieldName3, Object expected3, 
			String fieldName4, Object expected4, 
			String fieldName5, Object expected5, 
			String fieldName6, Object expected6, 
			String fieldName7, Object expected7
			) throws BindingException
	{
		try {
			List<Bean> result = new ArrayList<Bean>();
			Binding binding1 = getBinding(expected1);
			Binding binding2 = getBinding(expected2);
			Binding binding3 = getBinding(expected3);
			Binding binding4 = getBinding(expected4);
			Binding binding5 = getBinding(expected5);
			Binding binding6 = getBinding(expected6);
			Binding binding7 = getBinding(expected7);
			for (Bean item : items.values()) {
				Binding cb1 = item.getFieldBinding(fieldName1);
				Object cv1 = item.getField(fieldName1);
				boolean matches1 = (expected1==null && cv1==null) || (Bindings.equals(cb1, cv1, binding1, expected1));
				
				Binding cb2 = item.getFieldBinding(fieldName2);
				Object cv2 = item.getField(fieldName2);
				boolean matches2 = (expected2==null && cv2==null) || (Bindings.equals(cb2, cv2, binding2, expected2));

				Binding cb3 = item.getFieldBinding(fieldName3);
				Object cv3 = item.getField(fieldName3);
				boolean matches3 = (expected3==null && cv3==null) || (Bindings.equals(cb3, cv3, binding3, expected3));

				Binding cb4 = item.getFieldBinding(fieldName4);
				Object cv4 = item.getField(fieldName4);
				boolean matches4 = (expected4==null && cv4==null) || (Bindings.equals(cb4, cv4, binding4, expected4));

				Binding cb5 = item.getFieldBinding(fieldName5);
				Object cv5 = item.getField(fieldName5);
				boolean matches5 = (expected5==null && cv5==null) || (Bindings.equals(cb5, cv5, binding5, expected5));

				Binding cb6 = item.getFieldBinding(fieldName6);
				Object cv6 = item.getField(fieldName6);
				boolean matches6 = (expected6==null && cv6==null) || (Bindings.equals(cb6, cv6, binding6, expected6));

				Binding cb7 = item.getFieldBinding(fieldName7);
				Object cv7 = item.getField(fieldName7);
				boolean matches7 = (expected7==null && cv7==null) || (Bindings.equals(cb7, cv7, binding7, expected7));
				
//				if (expected2.equals("/RL10F001/XB_02#BINARY_VALUE") && cv2.equals("/RL10F001/XB_02#BINARY_VALUE"));
//					System.out.println("debug here");

				if ( matches1 && matches2 & matches3 & matches4 & matches5 & matches6 & matches7 ) result.add(item);				
			}
			/*
			if (result.isEmpty()) {
				System.out.println("No match for "+expected2);
			} else {
				if (result.size()>1) System.out.println("many matches for "+expected2); else
				System.out.println("match for "+expected2+" is "+result.iterator().next().getField(fieldName2));
			}*/
			return result;
		} catch (BindingConstructionException bce) {
			throw new BindingException(bce);
		}
	}
	

}
