package org.simantics.event.view.handler;

import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.event.ontology.EventResource;

/**
 * @author Tuukka Lehtonen
 */
public class TagAction extends Action {

    private final String virtualGraphId;
    private final String tagURI;
    private final boolean tag;
    protected final List<Resource> resources;

    /**
     * @param label
     * @param image
     * @param virtualGraphId
     * @param tagURI
     * @param tag <code>true</code> to add tag, <code>false</code> to remove tag
     * @param input
     */
    public TagAction(String label, ImageDescriptor image, String virtualGraphId, String tagURI, boolean tag, List<Resource> input) {
        super(label, image);

        this.virtualGraphId = virtualGraphId;
        this.tagURI = tagURI;
        this.tag = tag;
        this.resources = input;
    }

    @Override
    public void run() {
        Session session = Simantics.peekSession();
        if (session == null) return;

        final VirtualGraph vg = virtualGraphId == null ? null :
            session.getService(VirtualGraphSupport.class).getWorkspacePersistent(virtualGraphId);
        session.asyncRequest(new WriteRequest(vg) {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
                // Write tags
                Resource tr = graph.getResource(tagURI);
                for (Resource r : resources) {
                    if (tag)
                        graph.claim(r, tr, tr, r);
                    else
                        graph.deny(r, tr, r);
                }

                // Set milestone labels for all events of the event log
                if (tagURI.equals(EventResource.URIs.Milestone)) {
                    CorrectMilestoneLabelsAction.correctMilestoneLabels(graph, vg, resources);
                }

                // Perform any extra writes desired
                postTagWrite(graph);
            }
        });

    }

    public void postTagWrite(WriteGraph graph) throws DatabaseException {
    }

}
