/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.graphical.model;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.simantics.debug.graphical.model.Content;
import org.simantics.debug.graphical.model.Node;

public class Edge {
    private static final double ARROW_LENGTH = 10.0;
    private static final double ARROW_MIDDLE_LENGTH = 8.0;
    private static final double ARROW_RADIUS = 4.0;
    Node a;
    Node b;
    Content content;

    public Edge(Node a, Node b) {
        this.a = a;
        this.b = b;
    }

    public Node getA() {
        return this.a;
    }

    public Node getB() {
        return this.b;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public void render(Graphics2D g) {
        double dy;
        Point2D pa = this.a.clipLineFromCenter(this.b.x, this.b.y);
        Point2D pb = this.b.clipLineFromCenter(this.a.x, this.a.y);
        Path2D.Double path = new Path2D.Double();
        double x = pb.getX();
        double y = pb.getY();
        double dx = pa.getX() - x;
        double l = Math.sqrt(dx * dx + (dy = pa.getY() - y) * dy);
        if (!(l < 0.1)) {
            ((Path2D)path).moveTo(x, y);
            ((Path2D)path).lineTo(x + 10.0 * (dx /= l) + 4.0 * (dy /= l), y + 10.0 * dy - 4.0 * dx);
            ((Path2D)path).lineTo(x + 8.0 * dx, y + 8.0 * dy);
            ((Path2D)path).lineTo(x + 10.0 * dx - 4.0 * dy, y + 10.0 * dy + 4.0 * dx);
            path.closePath();
            g.fill(path);
            pb.setLocation(pb.getX() + dx * 8.0, pb.getY() + dy * 8.0);
        }
        g.draw(new Line2D.Double(pa, pb));
        if (this.content != null) {
            if (l < this.content.radiusX * 2.1) {
                double tx = 0.5 * (pa.getX() + pb.getX()) + Math.signum(dy) * this.content.radiusX;
                double ty = 0.5 * (pa.getY() + pb.getY()) - Math.signum(dx) * this.content.radiusY;
                this.content.render(g, tx, ty);
            } else {
                double ss = this.content.radiusY * 0.5 + 1.0;
                double tx = 0.5 * (pa.getX() + pb.getX()) - dy * ss;
                double ty = 0.5 * (pa.getY() + pb.getY()) + dx * ss;
                this.content.render(g, new AffineTransform(-dx, -dy, dy, -dx, tx, ty));
            }
        }
    }
}

