/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;

import java.util.concurrent.Semaphore;

import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.procedure.ListenerBase;

final public class TypeHierarchy extends UnaryQuery<InternalProcedure<IntSet>> {
    
//	public ArrayList<InternalProcedure<IntSet>> procs = null;
	
    private TypeHierarchy(final int resource) {
        super(resource);
    }
    
    final static void runner(ReadGraphImpl graph, final int r, final CacheEntry parent, final QueryProcessor provider, final ListenerBase listener, final InternalProcedure<IntSet> procedure) {

    	TypeHierarchy entry = (TypeHierarchy)provider.typeHierarchyMap.get(r);
        if(entry == null) {

        	entry = new TypeHierarchy(r);
        	entry.setPending();
        	entry.clearResult(provider.querySupport);
        	entry.putEntry(provider);
        	
            provider.performForEach(graph, entry, parent, listener, procedure);
            
        } else {
        	
            if(!entry.isReady()) {
            	synchronized(entry) {
                    if(!entry.isReady()) {
                        throw new IllegalStateException();
//                    	if(entry.procs == null) entry.procs = new ArrayList<InternalProcedure<IntSet>>();
//                    	entry.procs.add(procedure);
//						provider.registerDependencies(graph, entry, parent, listener, procedure, false);
//                    	return;
                    }
            	}
            }
            provider.performForEach(graph, entry, parent, listener, procedure);
        }

    }
    
    final public static void queryEach(ReadGraphImpl graph, final int r, final QueryProcessor provider, final CacheEntry parent, final ListenerBase listener, final InternalProcedure<IntSet> procedure) {
        
        if(parent == null && listener == null) {
        	TypeHierarchy entry = (TypeHierarchy)provider.typeHierarchyMap.get(r);
        	if(entry != null && entry.isReady()) { 
        		entry.performFromCache(graph, provider, procedure);
        		return;
        	}
        }
        
        runner(graph, r, parent, provider, listener, procedure);
         
    }
 	
 	@Override
 	public UnaryQuery<InternalProcedure<IntSet>> getEntry(QueryProcessor provider) {
        return provider.typeHierarchyMap.get(id);
 	}
 	
 	@Override
 	public void putEntry(QueryProcessor provider) {
        provider.typeHierarchyMap.put(id, this);
 	}

 	@Override
 	final public void removeEntry(QueryProcessor provider) {
 		provider.typeHierarchyMap.remove(id);
 	}

 	@Override
 	public IntSet computeForEach(ReadGraphImpl graph, final QueryProcessor provider, final InternalProcedure<IntSet> procedure, boolean store) {

        final IntSet result = new IntSet(provider.querySupport, id);
        
        final TIntProcedure addToResult = new TIntProcedure() {
            @Override
            public boolean execute(int r) {
            	result.add(r);
                return true;
            }
        };
        
        SuperTypes.queryEach(graph, id, provider, TypeHierarchy.this, null, new InternalProcedure<IntSet>() {

        	@Override
        	public void execute(ReadGraphImpl graph, IntSet types) {

        		types.forEach(addToResult);
        		addOrSet(graph, result, provider);
        		procedure.execute(graph, result); 

        	}

        	@Override
        	public void exception(ReadGraphImpl graph, Throwable t) {
        		procedure.exception(graph, t);
        	}

        });
        
        return result;
                        
    }
    
    @Override
    public String toString() {
    	return "TypeHierarchy[" + id + "]";
    }

    private void addOrSet(ReadGraphImpl graph, final IntSet value, QueryProcessor provider) {
    	
        assert(!isReady());

//        ArrayList<InternalProcedure<IntSet>> p = null;

        synchronized(this) {
        
            value.trim();
            setResult(value);
            setReady();
//            p = procs;
//            procs = null; 
        
        }

//        if(p != null) {
//	        IntSet v = (IntSet)getResult();
//	        if(v != null) {
//	            for(InternalProcedure<IntSet> proc : p) proc.execute(graph, v);
//	        }
//        }
        
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, InternalProcedure<IntSet> procedure) {
    	
    	assert(isReady());

    	if(handleException(graph, procedure)) return null;
    	
    	IntSet result = getResult();
    	
        procedure.execute(graph, result);
        
        return result;
        
    }
    
    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        
        final Semaphore s = new Semaphore(0);

        computeForEach(graph, provider, new InternalProcedure<IntSet>() {

        	@Override
        	public void execute(ReadGraphImpl graph, IntSet result) {
                s.release();
        	}

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
            	s.release();
                new Error("Error in recompute.", t).printStackTrace();
            }

        }, true);

        while(!s.tryAcquire()) {
        	provider.resume(graph);
        }
        
    }
    
    @Override
    boolean isImmutable(ReadGraphImpl graph) {
    	return graph.processor.isImmutable(id);
    }    
}
