/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import java.util.ArrayList;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.exception.DebugException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.QueryProcessor.AsyncBarrier;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.request.MultiRead;
import org.simantics.db.request.RequestFlags;
import org.simantics.utils.datastructures.Pair;

final public class MultiReadEntry<T> extends CacheEntryBase {

//    public ArrayList<Pair<AsyncMultiProcedure<T>, AsyncBarrier>> procs;

    protected MultiRead<T> request;
    
    public MultiReadEntry(MultiRead<T> request) {
    	this.request = request;
    }

    @Override
    int makeHash() {
    	return request.hashCode();
    }
    
    @Override
    public Object getOriginalRequest() {
        return request;
    }
    
    @Override
    public void discard() {
    	super.discard();
    	request = null;
    	setResult(null);
    }
    
    synchronized public void finish(AsyncReadGraph graph) {
    	
    	assert(isPending());

        ArrayList<Pair<AsyncMultiProcedure<T>, AsyncBarrier>> p = null;

        synchronized(this) {

        	setReady();
        	
//            p = procs;
//            procs = null; 
        
        }
        
//        if(p != null) {
//        	ArrayList<T> v = (ArrayList<T>)getResult();
//        	if(v != null) {
//        		for(Pair<AsyncMultiProcedure<T>, AsyncBarrier> pair : p) {
//        			for(T t : v) pair.first.execute(graph, t);
//        		}
//        	}
//        	for(Pair<AsyncMultiProcedure<T>, AsyncBarrier> pair : p) {
//        		pair.first.finished(graph);
//        		pair.second.dec();
//        	}
//        }
        
    }

    @Override
    final public void clearResult(QuerySupport support) {
        setResult(new ArrayList<T>());
    }

    final synchronized public void addOrSet(Object item) {

    	assert(isPending());

        ArrayList<T> value = (ArrayList<T>)getResult(); 
        value.add((T)item);
        
    }
    
    @Override
    final public Query getQuery() {
    	
        return new Query() {

			@Override
			public void recompute(ReadGraphImpl graph, Object provider, CacheEntry entry) {
				
				QueryProcessor qp = (QueryProcessor)provider;

				final ReadGraphImpl parentGraph = ReadGraphImpl.forRecompute(entry, qp); 
//                parentGraph.state.barrier.inc();

				try {

				    request.perform(parentGraph , new AsyncMultiProcedure<T>() {

                        @Override
                        public void execute(AsyncReadGraph graph, T result) {
                            addOrSet(result);
//                            parentGraph.state.barrier.dec();
                        }
                        
                        public void finished(AsyncReadGraph graph) {
                        	finish(graph);
//                            parentGraph.state.barrier.dec();
                        };
        				
        				@Override
        				public void exception(AsyncReadGraph graph, Throwable t) {
                            except(t);
//                            parentGraph.state.barrier.dec();
        	            }

                    });

//					parentGraph.waitAsync(request);

				} catch (Throwable t) {
                    except(t);
//                    parentGraph.state.barrier.dec();
                    if(DebugException.DEBUG) new DebugException(t).printStackTrace();
                }
				
			}

			@Override
			public void removeEntry(QueryProcessor processor) {
		    	processor.multiReadMap.remove(request);
			}

			@Override
			public int type() {
				return RequestFlags.INVALIDATE;
			}
			
			@Override
			public String toString() {
				if(request == null) return "DISCARDED";
				else return request.toString() + statusOrException;
			}
        	
        };
        
    }

    public void performFromCache(AsyncReadGraph graph, Object provider, Object procedure) {
        
        AsyncMultiProcedure<T> proc = (AsyncMultiProcedure<T>)procedure;

        if(isExcepted()) {
            
            try {
                proc.exception(graph, (Throwable)getResult());
            } catch (Throwable t) {
                t.printStackTrace();
            }
//            parentBarrier.dec();
            
        } else {
            
            final ArrayList<T> values = (ArrayList<T>)getResult();
            for(T value : values) {
                try {
                    proc.execute(graph, value);
                } catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            try {
                proc.finished(graph);
            } catch (Throwable t) {
                t.printStackTrace();
            }
//            parentBarrier.dec();

        }
        
    }
    
	@Override
	public void performFromCache(ReadGraphImpl graph, Object provider,
			Object procedure) {
		
		final AsyncMultiProcedure<T> proc = (AsyncMultiProcedure<T>)procedure;

        if(isExcepted()) {
            
            try {
                proc.exception(graph, (Throwable)getResult());
            } catch (Throwable t) {
                t.printStackTrace();
            }
            
        } else {
            
            final ArrayList<T> values = (ArrayList<T>)getResult();
            for(T value : values) {
                try {
                    proc.execute(graph, value);
                } catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            try {
                proc.finished(graph);
            } catch (Throwable t) {
                t.printStackTrace();
            }

        }
		
		
		
	}
	
	@Override
	public String toString() {
		if(request == null) return "DISCARDED";
		else return request.toString() + statusOrException;
	}

}
