/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;




abstract public class CollectionUnaryQuery<T> extends UnaryQuery<T> {
    
    public CollectionUnaryQuery(final int id) {
        super(id);
    }
    
    @Override
    public void clearResult(QuerySupport support) {
    	setResult(new IntArray());
    }
    
    @Override
    public void setReady() {
    	super.setReady();
    	IntArray v = (IntArray)getResult();
    	int size = v.size();
        if(size == 0) setResult(IntArray.EMPTY);
        else v.trim();
    }
    
}
