/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.request.RequestFlags;


abstract public class BinaryQuery<Procedure> extends CacheEntryBase implements Query {

	final public long id;

	public BinaryQuery(final long r1, final long r2) {
        assert(r1 != 0);
        assert(r2 != 0);
        id = id(r1,r2);
        assert(id != 0);
    }
	
	@Override
	int makeHash() {
		return r1() ^ r2();
	}
	
    final public int r1() {
        return (int)(id>>>32);
    }
    
    final public int r2() {
        return (int)id;
    }
    
    final protected static long id(long r1, long r2) {
        long result = (r1<<32) | (r2 & 0xffffffffL); 
        return result;
    }
    
    @Override
    public int type() {
        return RequestFlags.INVALIDATE;
    }
    
	@Override
    final public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        BinaryQuery<?> other = (BinaryQuery<?>)object;
        return id == other.id;
    }
	
    @Override
    final public Query getQuery() {
        return this;
    }
    
    @Override
    public void recompute(ReadGraphImpl graph, Object provider, CacheEntry entry) {
        recompute(graph, (QueryProcessor)provider);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public void performFromCache(ReadGraphImpl graph, Object provider, Object procedure) {
        performFromCache(graph, (QueryProcessor)provider, (Procedure)procedure);
    }

    abstract public void recompute(ReadGraphImpl graph, QueryProcessor provider);
    abstract public void computeForEach(ReadGraphImpl graph, QueryProcessor provider, Procedure procedure, boolean store);
    abstract public void performFromCache(ReadGraphImpl graph, QueryProcessor provider, Procedure procedure);
    abstract public void putEntry(QueryProcessor provider);
    abstract public void removeEntry(QueryProcessor provider);
    abstract public BinaryQuery<Procedure> getEntry(QueryProcessor provider);

}
