/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.concurrent.Semaphore;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringIndexModifier;
import org.simantics.db.layer0.adapter.TObjectIntPair;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.utils.representation.StringRepresentation2;
import org.simantics.utils.ui.ErrorLogger;

public abstract class GraphStringIndexModifier
implements Labeler.Modifier {
    protected NodeContext context;
    protected Session session;
    protected int index;
    protected String initialValue;
    protected StringIndexModifier modifier;
    protected Semaphore modifierReady = new Semaphore(0);
    protected Throwable modifierFailed;

    public GraphStringIndexModifier(NodeContext context, Session session, int index) throws DatabaseException {
        this.context = context;
        this.session = session;
        this.index = index;
        final Resource r = this.getResourceToModify();
        if (r == null) {
            throw new IllegalArgumentException("This modifier does not work for INodeContexts that are not adaptable to a Resource. The context input is: " + context.getConstant(BuiltinKeys.INPUT));
        }
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                GraphStringIndexModifier.this.initialValue = GraphStringIndexModifier.this.getInitialValue(g);
                GraphStringIndexModifier.this.modifier = (StringIndexModifier)g.adapt(r, StringIndexModifier.class);
                GraphStringIndexModifier.this.initializeGraphModifier(g);
                GraphStringIndexModifier.this.modifierReady.release();
            }
        });
    }

    protected String getInitialValue(ReadGraph g) throws DatabaseException {
        StringRepresentation2 sr = (StringRepresentation2)g.adapt(this.getResourceToModify(), StringRepresentation2.class);
        String s = sr.get(g, this.index);
        return s;
    }

    protected void initializeGraphModifier(ReadGraph g) {
    }

    protected Resource getResourceToModify() {
        Resource r = (Resource)this.context.getAdapter(Resource.class);
        if (r == null) {
            throw new AssertionError((Object)"context.getAdapter(Resource.class) returned null");
        }
        return r;
    }

    protected StringIndexModifier getModifier() {
        return this.modifier;
    }

    public String getValue() {
        return this.initialValue;
    }

    public String isValid(String label) {
        if (this.modifierFailed != null) {
            return "Could not resolve validator for this value, modification denied. Reason: " + this.modifierFailed.getMessage();
        }
        if (this.modifier == null) {
            return "";
        }
        TObjectIntPair<String> t = this.createModifierInput(label);
        return this.modifier.isValid(t);
    }

    public final void modify(String label) {
        if (this.modifier == null) {
            try {
                this.modifierReady.acquire();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        if (this.modifierFailed != null) {
            return;
        }
        final TObjectIntPair<String> t = this.createModifierInput(label);
        if (!this.verifyModification(t)) {
            return;
        }
        this.session.asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                GraphStringIndexModifier.this.doModify(graph, (TObjectIntPair<String>)t);
            }
        }, parameter -> {
            if (parameter != null) {
                ErrorLogger.defaultLogError((Throwable)parameter);
            }
        });
    }

    protected boolean verifyModification(TObjectIntPair<String> label) {
        return true;
    }

    public abstract void doModify(WriteGraph var1, TObjectIntPair<String> var2) throws DatabaseException;

    public abstract TObjectIntPair<String> createModifierInput(String var1);
}

