/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.basicexpression;

import java.io.PushbackReader;
import java.io.StringReader;

import org.simantics.basicexpression.analysis.DepthFirstAdapter;
import org.simantics.basicexpression.lexer.Lexer;
import org.simantics.basicexpression.node.Start;
import org.simantics.basicexpression.parser.Parser;

public class Expressions {

	private static final boolean DEBUG = false;
	
    public static void evaluate(String expression, DepthFirstAdapter evaluator) {
        
        try
        {
            // Create a Parser instance.
            Parser p =
                new Parser(
                        new Lexer(
                                new PushbackReader(new StringReader(expression))));

            // Parse the input.
            Start tree = p.parse();
            
            if(DEBUG)
            	tree.apply(new PrettyPrintExpressionVisitor());
            
//            System.out.println("tree=" + tree.getClass().getName());
            
            // Apply the translation.
            tree.apply(evaluator);

        }
        catch(Exception e)
        {
        	e.printStackTrace();
        	evaluator.except(e);
        }        
        
    }

}
