/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmil.core;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.Simantics;
import org.simantics.fmil.core.ExecEnvironment;
import org.simantics.fmil.core.FMILException;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMIL {
    private static final Logger LOGGER = LoggerFactory.getLogger(FMIL.class);
    private static int OK = 0;
    private static int ERROR = 1;
    private static String UNSATISFIED_LINK = "Method not found. DLL might not be loaded properly.";
    private static String TEMP_FMU_DIRECTORY_NAME = "fmil";
    public static String TEMP_FMU_COMMON_DIRECTORY;
    public static String LOCK_FILE_NAME;
    public static Object syncObject;
    private String fmuDir;
    private int id;
    public String TEMP_FOLDER_1;
    public String TEMP_FOLDER_2;
    public String TEMP_FMU_DIRECTORY;
    private String dirName;
    private String[] variableNames;
    private String[] variableDescriptions;
    private String[] variableDeclaredTypes;
    private int[] variableReferences;
    private int[] variableTypes;
    private int[] variableCausalities;
    private int[] variableVariabilities;
    private String[] declaredTypes;
    private String[] declaredTypeDescriptions;
    private String[] declaredTypeQuantities;
    private String[] declaredTypeUnits;
    private TObjectIntHashMap<String> variableMap = new TObjectIntHashMap();
    private Set<String> subscriptionSet = new HashSet<String>();
    private TIntArrayList subscription = new TIntArrayList();
    private ArrayList<String> subscribedNames = new ArrayList();
    private int fmuN = 0;
    private boolean fmuLoaded = false;
    private FileChannel channel;
    private FileLock lock;

    static {
        LOCK_FILE_NAME = "fmil.lock";
        syncObject = new Object();
        File[] libraries = new File[2];
        Bundle bundle = null;
        ExecEnvironment env = ExecEnvironment.calculate();
        if (env.os == ExecEnvironment.OSType.WINDOWS) {
            if (env.arch == ExecEnvironment.ARCHType.X86) {
                bundle = Platform.getBundle((String)"org.simantics.fmil.win32");
            } else if (env.arch == ExecEnvironment.ARCHType.X86_64) {
                bundle = Platform.getBundle((String)"org.simantics.fmil.win64");
            }
        }
        if (bundle != null) {
            try {
                String root = FileLocator.getBundleFile(bundle).getAbsolutePath();
                libraries[0] = new File(root, "libraries/fmilib_shared.dll");
                libraries[1] = new File(root, "libraries/FMUSimulator.dll");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File[] fileArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            File library = fileArray[n2];
            if (library == null) {
                System.err.println("FMU library not loaded. FMU simulation not working.");
            } else if (!library.isFile()) {
                System.err.println(String.valueOf(library.getAbsolutePath()) + " not found");
            } else {
                try {
                    System.load(library.getAbsolutePath());
                }
                catch (Throwable t) {
                    System.err.println(t.getMessage());
                }
            }
            ++n2;
        }
        File dir = Simantics.getTemporaryDirectory((String)TEMP_FMU_DIRECTORY_NAME);
        TEMP_FMU_COMMON_DIRECTORY = dir.getAbsolutePath();
    }

    public List<String> getSubscribedNames() {
        return this.subscribedNames;
    }

    public boolean subscribe(String name) throws FMILException {
        int vr = this.variableMap.get((Object)name);
        if (vr == 0) {
            return false;
        }
        if (!this.subscriptionSet.add(name)) {
            return false;
        }
        this.subscribedNames.add(name);
        System.err.println("subscribed : " + name + " => " + this.subscribedNames.size());
        this.subscription.add(vr);
        this.subscribe(new int[]{vr});
        return true;
    }

    public FMIL() {
        File tempDir = new File(TEMP_FMU_COMMON_DIRECTORY, UUID.randomUUID().toString());
        tempDir.mkdir();
        this.TEMP_FMU_DIRECTORY = tempDir.getAbsolutePath();
        this.dirName = UUID.randomUUID().toString();
        File fmuDir = new File(this.TEMP_FMU_DIRECTORY, this.dirName);
        fmuDir.mkdir();
        this.TEMP_FOLDER_1 = fmuDir.toString();
        this.TEMP_FOLDER_2 = String.valueOf(fmuDir.toString()) + "_2";
        this.lockFMUDirectory();
    }

    public int getModelIDNew() {
        return this.id;
    }

    public String getModelID() {
        return this.dirName;
    }

    public String getFmuDir() {
        return this.fmuDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFMUFile(String path) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            if (this.fmuN % 2 == 0) {
                this.fmuDir = this.TEMP_FOLDER_1;
                ++this.fmuN;
            } else {
                this.fmuDir = this.TEMP_FOLDER_2;
                this.fmuN = 0;
            }
            File tempDir = new File(this.fmuDir);
            if (tempDir.isDirectory()) {
                try {
                    FileUtils.deleteAll((File)tempDir);
                }
                catch (IOException e) {
                    throw new FMILException("Could not create temp folder for fmu");
                }
                tempDir.mkdir();
            } else {
                tempDir.mkdir();
            }
            try {
                String tmpPath = tempDir.getAbsolutePath();
                if (!tmpPath.endsWith("\\")) {
                    tmpPath = String.valueOf(tmpPath) + "\\";
                }
                this.id = this.loadFMUFile_(path, tmpPath);
                this.getAllVariables();
                this.getAllVariableReferences();
                int i = 0;
                while (i < this.variableNames.length) {
                    this.variableMap.put((Object)this.variableNames[i], this.variableReferences[i]);
                    ++i;
                }
                this.fmuLoaded = true;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK, err);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int loadFMUFile_(String var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStepLength(double step) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setStepLength_(this.getModelIDNew(), step);
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int setStepLength_(int var1, double var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiateSimulation() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.instantiateSimulation_(this.getModelIDNew());
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int instantiateSimulation_(int var1) throws FMILException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSimulation() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.initializeSimulation_(this.getModelIDNew());
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int initializeSimulation_(int var1) throws FMILException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(int[] variables) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.subscribe_(this.getModelIDNew(), variables);
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int subscribe_(int var1, int[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRealValue(String name, double value) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setRealValue_(this.getModelIDNew(), this.variableMap.get((Object)name), value);
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRealValue(int variableReference, double value) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setRealValue_(this.getModelIDNew(), variableReference, value);
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int setRealValue_(int var1, int var2, double var3) throws FMILException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateStep() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.simulateStep_(this.getModelIDNew());
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int simulateStep_(int var1) throws FMILException;

    public double[] getSubscribedResults() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                double[] results = new double[this.subscription.size()];
                return this.getSubscribedResults_(this.getModelIDNew(), results);
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native double[] getSubscribedResults_(int var1, double[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadFMU() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                this.unlockFMUDirectory();
                if (this.fmuLoaded) {
                    int ret = this.unloadFMU_(this.getModelIDNew());
                    if (ret != OK) {
                        LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                    }
                    this.fmuLoaded = false;
                }
                this.removeFMUDirectoryContents();
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int unloadFMU_(int var1) throws FMILException;

    public double getTime() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getTime_(this.getModelIDNew());
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native double getTime_(int var1);

    public String[] getAllVariables() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableNames == null) {
                    this.variableNames = this.getAllVariables_(this.getModelIDNew());
                }
                return this.variableNames;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllVariables_(int var1);

    public String[] getAllVariableDescriptions() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableDescriptions == null) {
                    this.variableDescriptions = this.getAllVariableDescriptions_(this.getModelIDNew());
                }
                return this.variableDescriptions;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllVariableDescriptions_(int var1);

    public String[] getAllVariableDeclaredTypes() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableDeclaredTypes == null) {
                    this.variableDeclaredTypes = this.getAllVariableDeclaredTypes_(this.getModelIDNew());
                }
                return this.variableDeclaredTypes;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllVariableDeclaredTypes_(int var1);

    public int[] getAllVariableReferences() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableReferences == null) {
                    this.variableReferences = this.getAllVariableReferences_(this.getModelIDNew(), new int[this.variableNames.length]);
                }
                return this.variableReferences;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int[] getAllVariableReferences_(int var1, int[] var2);

    public int[] getAllVariableTypes() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableTypes == null) {
                    this.variableTypes = this.getAllVariableTypes_(this.getModelIDNew(), new int[this.variableNames.length]);
                }
                return this.variableTypes;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int[] getAllVariableTypes_(int var1, int[] var2);

    public int[] getAllVariableCausalities() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableCausalities == null) {
                    this.variableCausalities = this.getAllVariableCausalities_(this.getModelIDNew(), new int[this.variableNames.length]);
                }
                return this.variableCausalities;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int[] getAllVariableCausalities_(int var1, int[] var2);

    public int[] getAllVariableVariabilities() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableVariabilities == null) {
                    this.variableVariabilities = this.getAllVariableVariabilities_(this.getModelIDNew(), new int[this.variableNames.length]);
                }
                return this.variableVariabilities;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int[] getAllVariableVariabilities_(int var1, int[] var2);

    public String[] getAllDeclaredTypes() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.declaredTypes == null) {
                    this.declaredTypes = this.getAllDeclaredTypes_(this.getModelIDNew());
                }
                return this.declaredTypes;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllDeclaredTypes_(int var1);

    public String[] getAllDeclaredTypeDescriptions() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.declaredTypeDescriptions == null) {
                    this.declaredTypeDescriptions = this.getAllDeclaredTypeDescriptions_(this.getModelIDNew());
                }
                return this.declaredTypeDescriptions;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllDeclaredTypeDescriptions_(int var1);

    public String[] getAllDeclaredTypeQuantities() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.declaredTypeQuantities == null) {
                    this.declaredTypeQuantities = this.getAllDeclaredTypeQuantities_(this.getModelIDNew());
                }
                return this.declaredTypeQuantities;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllDeclaredTypeQuantities_(int var1);

    public String[] getAllDeclaredTypeUnits() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.declaredTypeUnits == null) {
                    this.declaredTypeUnits = this.getAllDeclaredTypeUnits_(this.getModelIDNew());
                }
                return this.declaredTypeUnits;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllDeclaredTypeUnits_(int var1);

    public double getRealValue(String name) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                double result = this.getRealValue_(this.getModelIDNew(), this.variableMap.get((Object)name));
                System.err.println("getRealValue " + name + " = " + result);
                return result;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native double getRealValue_(int var1, int var2);

    private boolean lockFMUDirectory() {
        try {
            File lockFile = new File(this.TEMP_FMU_DIRECTORY, LOCK_FILE_NAME);
            if (!lockFile.isFile()) {
                lockFile.createNewFile();
            }
            this.channel = new RandomAccessFile(lockFile, "rw").getChannel();
            this.lock = this.channel.lock();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean unlockFMUDirectory() {
        try {
            if (this.lock != null) {
                this.lock.release();
            }
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean removeFMUDirectoryContents() {
        try {
            File tempDir = new File(this.TEMP_FMU_DIRECTORY);
            FileUtils.deleteAll((File)tempDir);
            tempDir.delete();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            try {
                this.unloadFMU();
            }
            catch (Throwable t) {
                LOGGER.error("Could not unload native FMU!", t);
                super.finalize();
            }
        }
        finally {
            super.finalize();
        }
    }
}

