/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.fmi.studio.core.FMIExperiment;
import org.simantics.fmi.studio.core.ImmediateNodeManager;
import org.simantics.fmi.studio.core.StructuralNode;
import org.simantics.fmi.studio.core.StructuralPropertyNode;
import org.simantics.fmil.core.FMILException;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

public class FMINodeManager
extends ImmediateNodeManager<StructuralNode> {
    private final String id;
    private final FMIExperiment experiment;
    static final Set<String> COMPONENT_CLASS = Collections.singleton("http://www.simantics.org/Structural-1.2/Component");

    public FMINodeManager(String id, FMIExperiment experiment) {
        this.id = id;
        this.experiment = experiment;
    }

    FMIFolderNode getRoot() {
        return this.experiment.getRootNode();
    }

    public String getName(StructuralNode node) {
        if (this.experiment.getRootNode().equals(node)) {
            int lastSlash = this.id.lastIndexOf("/");
            if (lastSlash == -1) {
                throw new IllegalStateException("Invalid realm id " + this.id);
            }
            String name = this.id.substring(lastSlash + 1);
            return name;
        }
        return node.name;
    }

    public StructuralNode getChild(StructuralNode node, String name) throws NodeManagerException {
        if (node instanceof FMIChildNode) {
            return ((FMIChildNode)node).getChild(name);
        }
        return null;
    }

    public StructuralNode getProperty(StructuralNode node, String name) throws NodeManagerException {
        if (node instanceof FMIVariableNode) {
            return ((FMIVariableNode)node).getProperty(name);
        }
        return null;
    }

    public List<StructuralNode> getChildren(StructuralNode node) throws NodeManagerException {
        if (node instanceof FMIChildNode) {
            return ((FMIChildNode)node).getChildren();
        }
        return Collections.emptyList();
    }

    public List<StructuralNode> getProperties(StructuralNode node) throws NodeManagerException {
        if (node instanceof FMIVariableNode) {
            return ((FMIVariableNode)node).getProperties();
        }
        return Collections.emptyList();
    }

    public Datatype getDatatype(StructuralNode node) throws NodeManagerException {
        return Datatypes.DOUBLE;
    }

    public Object getValue(StructuralNode node, Binding binding) throws NodeManagerException {
        try {
            return this.experiment.getVariableValue(node);
        }
        catch (FMILException e) {
            throw new NodeManagerException((Throwable)e);
        }
    }

    public void setValue(StructuralNode node, Object value, Binding binding) throws NodeManagerException {
        try {
            this.experiment.setVariableValue(node, value);
        }
        catch (FMILException e) {
            throw new NodeManagerException((Throwable)e);
        }
    }

    public Set<String> getClassifications(StructuralNode node) throws NodeManagerException {
        if (node instanceof FMIVariableNode) {
            return COMPONENT_CLASS;
        }
        return Collections.emptySet();
    }

    public String getPropertyURI(StructuralNode parent, StructuralNode property) {
        return "http://www.simantics.org/FMIStudio-1.0/RealVariable/value";
    }

    public List<String> getChildNames(StructuralNode node) throws NodeManagerException {
        List<StructuralNode> children = this.getChildren(node);
        if (children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(children.size());
        for (StructuralNode n : children) {
            result.add(n.name);
        }
        return result;
    }

    public List<String> getPropertyNames(StructuralNode node) throws NodeManagerException {
        List<StructuralNode> properties = this.getProperties(node);
        if (properties.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(properties.size());
        for (StructuralNode n : properties) {
            result.add(n.name);
        }
        return result;
    }

    public Variant getValue(StructuralNode node) throws NodeManagerException {
        Object value = this.getValue(node, (Binding)Bindings.DOUBLE);
        if (value == null) {
            return null;
        }
        return Variant.ofInstance((Object)value);
    }

    public static class FMIChildNode
    extends StructuralNode {
        private List<StructuralNode> children = Collections.emptyList();

        public FMIChildNode(StructuralNode parent, String name) {
            super(parent, name);
        }

        public void addChild(FMIChildNode child) {
            if (this.children.isEmpty()) {
                this.children = new ArrayList<StructuralNode>();
            }
            this.children.add(child);
        }

        public List<StructuralNode> getChildren() {
            return this.children;
        }

        public FMIChildNode getChild(String name) {
            for (StructuralNode n : this.children) {
                if (!name.equals(n.name)) continue;
                return (FMIChildNode)n;
            }
            return null;
        }

        public String getPath() {
            if (this.parent == null) {
                return "";
            }
            if (this.parent.parent == null) {
                return this.name;
            }
            return String.valueOf(((FMIChildNode)this.parent).getPath()) + "." + this.name;
        }

        public String toString() {
            return "FMIChildNode " + this.getPath();
        }
    }

    public static class FMIFolderNode
    extends FMIChildNode {
        public FMIFolderNode(StructuralNode parent, String name) {
            super(parent, name);
        }
    }

    public static class FMIValueNode
    extends StructuralPropertyNode {
        public FMIValueNode(StructuralNode parent) {
            super(parent, "value");
        }
    }

    public static class FMIVariableNode
    extends FMIChildNode {
        private final List<StructuralNode> value = Collections.singletonList(new FMIValueNode(this));

        public FMIVariableNode(StructuralNode parent, String name) {
            super(parent, name);
        }

        public List<StructuralNode> getProperties() {
            return this.value;
        }

        public StructuralNode getProperty(String name) {
            if ("value".equals(name)) {
                return this.value.get(0);
            }
            return null;
        }
    }
}

