/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.core;

import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.charts.ITrendSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.fmi.studio.core.Activator;
import org.simantics.fmi.studio.core.FMIDatasource;
import org.simantics.fmi.studio.core.FMINodeManager;
import org.simantics.fmi.studio.core.FMIRealm;
import org.simantics.fmi.studio.core.StructuralNode;
import org.simantics.fmi.studio.core.TrendSupport;
import org.simantics.fmi.studio.stubs.FMIStudioResource;
import org.simantics.fmil.core.FMIL;
import org.simantics.fmil.core.FMILException;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.experiment.IExperimentStatusListener;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMIExperiment
implements IDynamicExperiment {
    private static final Logger LOGGER = LoggerFactory.getLogger(FMIExperiment.class);
    final Map<String, Object> values;
    private FMIL fmu;
    private FMIRealm realm;
    private FMIDatasource datasource;
    private TrendSupport trendSupport;
    private Resource run;
    private Resource model;
    private String identifier;
    private List<String> variableNames;
    private FMINodeManager.FMIFolderNode ROOT;
    private boolean initialized = false;
    Runnable refresher = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (FMIExperiment.this.realm == null) {
                return;
            }
            try {
                List sub = FMIExperiment.this.fmu.getSubscribedNames();
                double[] results = FMIExperiment.this.fmu.getSubscribedResults();
                int i = 0;
                while (i < results.length) {
                    FMIExperiment.this.values.put((String)sub.get(i), results[i]);
                    ++i;
                }
                FMIExperiment.this.datasource.notifyStep();
                FMIExperiment.this.realm.refreshVariables(false, 500000000L);
                1 var3_6 = this;
                synchronized (var3_6) {
                    FMIExperiment.this.lastRefresh = System.nanoTime();
                    FMIExperiment.this.refreshPending = false;
                }
            }
            catch (FMILException e) {
                e.printStackTrace();
            }
            catch (NodeManagerException e) {
                e.printStackTrace();
            }
        }
    };
    Runnable refresherScheduler = new Runnable(){

        @Override
        public void run() {
            FMIExperiment.this.realm.asyncExec(FMIExperiment.this.refresher);
        }
    };
    long quietTime = 500000000L;
    long lastRefresh = 0L;
    boolean refreshPending = false;
    ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    long simulationStepNs = BigDecimal.valueOf(0.1).multiply(BigDecimal.valueOf(1.0E9)).longValue();

    public FMINodeManager.FMIFolderNode getRootNode() {
        return this.ROOT;
    }

    private void createNodeImpl(FMINodeManager.FMIFolderNode folder, String variableName) {
        String[] parts = variableName.split("\\.");
        int i = 0;
        while (i < parts.length) {
            if (i == parts.length - 1) {
                FMINodeManager.FMIVariableNode variable = new FMINodeManager.FMIVariableNode(folder, parts[i]);
                folder.addChild(variable);
            } else {
                FMINodeManager.FMIChildNode node = folder.getChild(parts[i]);
                if (node == null) {
                    FMINodeManager.FMIFolderNode child = new FMINodeManager.FMIFolderNode(folder, parts[i]);
                    folder.addChild(child);
                    folder = child;
                } else {
                    folder = (FMINodeManager.FMIFolderNode)node;
                }
            }
            ++i;
        }
    }

    private FMINodeManager.FMIFolderNode createNodes(String[] names) {
        FMINodeManager.FMIFolderNode root = new FMINodeManager.FMIFolderNode(null, "");
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.createNodeImpl(root, name);
            ++n2;
        }
        return root;
    }

    public FMIExperiment(ReadGraph graph, FMIRealm realm, String id) throws DatabaseException {
        this.realm = realm;
        try {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            FMIStudioResource FMI = FMIStudioResource.getInstance((ReadGraph)graph);
            this.run = graph.getResource(id);
            this.model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(this.run));
            String fmuPath = (String)graph.getRelatedValue(this.model, FMI.Model_fmuPath, (Binding)Bindings.STRING);
            Path fmuFile = Activator.stateLocation().resolve(fmuPath);
            if (!Files.exists(fmuFile, new LinkOption[0])) {
                throw new DatabaseException("FMU file for " + id + " does not exist in " + fmuFile.toAbsolutePath());
            }
            this.identifier = (String)graph.getRelatedValue(this.run, L0.HasName, (Binding)Bindings.STRING);
            this.fmu = new FMIL();
            this.fmu.loadFMUFile(fmuFile.toAbsolutePath().toString());
            this.fmu.instantiateSimulation();
            String[] names = this.fmu.getAllVariables();
            this.ROOT = this.createNodes(names);
            this.variableNames = new ArrayList<String>(names.length);
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.variableNames.add(name);
                ++n2;
            }
            if (!this.initialized) {
                try {
                    this.fmu.initializeSimulation();
                }
                catch (FMILException e) {
                    e.printStackTrace();
                }
                this.initialized = true;
            }
            this.values = new HashMap<String, Object>();
            for (String s : this.variableNames) {
                this.values.put(s, 0.0);
            }
            this.datasource = new FMIDatasource(this);
            if (this.trendSupport != null) {
                this.trendSupport.dispose();
            }
            this.trendSupport = new TrendSupport(this);
            try {
                this.trendSupport.initializeHistoryCollection(graph);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.fmi.studio.core", "Failed to initialize history collection and trending. See exception for details.", (Throwable)e));
            }
            this.changeState(ExperimentState.STOPPED);
        }
        catch (FMILException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public <T> T getService(Class<T> clazz) {
        if (ITrendSupport.class.equals(clazz)) {
            return (T)this.trendSupport;
        }
        return null;
    }

    public List<String> getVariables() {
        return this.variableNames;
    }

    public Type getVariableType(String name) {
        return Types.DOUBLE;
    }

    public void subscribe(String id) throws FMILException {
        if (this.fmu.subscribe(id)) {
            this.scheduleRefresh();
        }
    }

    public Object getVariableValue(StructuralNode node) throws FMILException {
        if (node instanceof FMINodeManager.FMIValueNode) {
            String id = ((FMINodeManager.FMIChildNode)node.parent).getPath();
            this.subscribe(id);
            return this.values.get(id);
        }
        return null;
    }

    public Object getVariableValue(String key) throws FMILException {
        this.subscribe(key);
        return this.values.get(key);
    }

    public void setVariableValue(StructuralNode node, Object value) throws FMILException {
        if (node instanceof FMINodeManager.FMIValueNode) {
            String id = ((FMINodeManager.FMIChildNode)node.parent).getPath();
            if (value instanceof Double) {
                this.fmu.setRealValue(id, ((Double)value).doubleValue());
                this.scheduleRefresh();
            }
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ExperimentState getState() {
        return this.realm.getExperimentState();
    }

    public ExperimentState getState(ReadGraph graph) throws DatabaseException {
        return this.realm.getState(graph);
    }

    public void changeState(ExperimentState state) {
        this.realm.changeState(state);
    }

    public Resource getResource() {
        return this.run;
    }

    public Resource getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(IProgressMonitor monitor) {
        block9: {
            this.changeState(ExperimentState.DISPOSED);
            ArrayList arrayList = this.realm.tasks;
            synchronized (arrayList) {
                this.realm.tasks.notifyAll();
            }
            try {
                try {
                    this.fmu.unloadFMU();
                }
                catch (FMILException e) {
                    LOGGER.error("FMIExperiment.shutdown: fmu.unloadFMU failed", (Throwable)e);
                    this.fmu = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.fmu = null;
                throw throwable;
            }
            this.fmu = null;
        }
        if (this.trendSupport != null) {
            this.trendSupport.dispose();
            this.trendSupport = null;
        }
        this.datasource = null;
        this.realm = null;
    }

    public void addListener(IExperimentListener listener) {
    }

    public void removeListener(IExperimentListener listener) {
    }

    public void addStatusListener(IExperimentStatusListener listener) {
    }

    public void removeStatusListener(IExperimentStatusListener listener) {
    }

    public Lock getDatasourceLock() {
        return null;
    }

    public Accessor getAccessor() {
        return null;
    }

    public void refresh(Session session) {
    }

    public void refresh(RequestProcessor session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRefresh() {
        Runnable runnable = this.refresher;
        synchronized (runnable) {
            if (this.refreshPending) {
                return;
            }
            this.refreshPending = true;
            long delta = System.nanoTime() - this.lastRefresh;
            if (delta > this.quietTime) {
                this.refresherScheduler.run();
            } else {
                long waitTime = this.quietTime - delta;
                this.scheduler.schedule(this.refresherScheduler, waitTime, TimeUnit.NANOSECONDS);
            }
        }
    }

    public void simulate(boolean enabled) {
        if (enabled) {
            if (!this.initialized) {
                try {
                    this.fmu.initializeSimulation();
                }
                catch (FMILException e) {
                    e.printStackTrace();
                }
                this.initialized = true;
            }
            this.realm.setSimulationStepNs(this.simulationStepNs);
            long runDurationNs = Long.MAX_VALUE;
            this.realm.runDuration(runDurationNs);
        } else {
            this.realm.runDuration(0L);
        }
    }

    public void simulateDuration(double duration) {
        if (!this.initialized) {
            try {
                this.fmu.initializeSimulation();
            }
            catch (FMILException e) {
                e.printStackTrace();
            }
            this.initialized = true;
        }
        long simulationStepNs = BigDecimal.valueOf(duration).multiply(BigDecimal.valueOf(1.0E9)).longValue();
        this.realm.setSimulationStepNs(simulationStepNs);
        this.realm.runDuration(simulationStepNs);
    }

    public void rewindTo(double time) {
    }

    public void saveState() {
    }

    public Datasource getDatasource() {
        return this.datasource;
    }

    public double getTime() {
        try {
            return this.fmu.getTime();
        }
        catch (FMILException e) {
            LOGGER.error("FMIExperiment.getTime failed", (Throwable)e);
            return 0.0;
        }
    }

    public void doStep(double stepLength) {
        try {
            this.fmu.setStepLength(stepLength);
            this.fmu.simulateStep();
            this.refresher.run();
        }
        catch (FMILException e) {
            e.printStackTrace();
        }
    }
}

