/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulator.variable.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSimulatorThread
extends Thread
implements Realm {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSimulatorThread.class);
    private StateExternalRead stateRead = new StateExternalRead(this);
    private ExperimentState state = ExperimentState.INITIALIZING;
    private long runStart = 0L;
    private double desiredRealtimeRatio = 1000.0;
    private double obtainedRealtimeRatio = 1.0;
    private long runTimeNs = 0L;
    private long endTimeNs = 0L;
    protected long simulationStepNs = 0L;
    protected double stepInSeconds = 1.0;
    private long rt;
    private long rt_l;
    protected ArrayList<Runnable> tasks = new ArrayList();
    Thread executorThread = this;
    Semaphore beginSyncExec = new Semaphore(0);
    Semaphore endSyncExec = new Semaphore(0);
    Runnable scheduleSyncExec = new Runnable(){

        @Override
        public void run() {
            DynamicSimulatorThread.this.beginSyncExec.release();
            try {
                DynamicSimulatorThread.this.endSyncExec.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    private void updateTimes() {
        long time = System.nanoTime();
        long elapsed = time - this.runStart;
        this.obtainedRealtimeRatio = this.longToDoubleDivision(this.runTimeNs, elapsed);
    }

    protected double longToDoubleDivision(long l1, long l2) {
        this.rt = l1 / l2;
        this.rt_l = l1 % l2;
        double d = (double)this.rt_l / (double)l2;
        return d += (double)this.rt;
    }

    public void step() {
    }

    boolean inState(ExperimentState state) {
        return state.equals((Object)this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (!this.inState(ExperimentState.DISPOSED)) {
            block16: {
                if (!this.inState(ExperimentState.RUNNING)) ** GOTO lbl43
                this.step();
                this.runTimeNs += this.simulationStepNs;
                this.updateTimes();
                this.runTasks();
                while (this.obtainedRealtimeRatio > this.desiredRealtimeRatio) {
                    ran = this.runTasks();
                    if (ran == 0) {
                        elapsed = System.nanoTime() - this.runStart;
                        deltaNs = BigDecimal.valueOf(this.runTimeNs).divide(BigDecimal.valueOf(this.desiredRealtimeRatio)).longValue() - elapsed;
                        deltaMs = deltaNs / 1000000L;
                        deltaNsRem = (int)(deltaNs % 1000000L);
                        if (deltaNs > 0L) {
                            var9_9 = this.tasks;
                            synchronized (var9_9) {
                                try {
                                    this.tasks.wait(deltaMs, deltaNsRem);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    this.updateTimes();
                }
                break block16;
lbl-1000:
                // 1 sources

                {
                    var1_2 = this.tasks;
                    synchronized (var1_2) {
                        ran = this.runTasks();
                        if (ran == 0) {
                            try {
                                this.tasks.wait(0x7FFFFFFFL);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        continue;
                    }
lbl43:
                    // 3 sources

                    ** while (!this.inState((ExperimentState)ExperimentState.RUNNING) && !this.inState((ExperimentState)ExperimentState.DISPOSED))
                }
            }
            if (this.runTimeNs < this.endTimeNs || this.inState(ExperimentState.DISPOSED)) continue;
            this.changeState(ExperimentState.STOPPED);
        }
        this.onDispose();
    }

    public void onDispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runTasks() {
        ArrayList<Runnable> todo = new ArrayList<Runnable>();
        ArrayList<Runnable> arrayList = this.tasks;
        synchronized (arrayList) {
            todo.addAll(this.tasks);
            this.tasks.clear();
        }
        for (Runnable r : todo) {
            r.run();
        }
        return todo.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(Runnable runnable) {
        ArrayList<Runnable> arrayList = this.tasks;
        synchronized (arrayList) {
            this.tasks.add(runnable);
            this.tasks.notify();
        }
    }

    public void syncExec(Runnable runnable) throws InterruptedException {
        if (this.executorThread == Thread.currentThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("syncExec in current thread failed", t);
            }
            return;
        }
        this.queue(this.scheduleSyncExec);
        this.beginSyncExec.acquire();
        Thread oldThread = this.executorThread;
        this.executorThread = Thread.currentThread();
        try {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("syncExec failed", t);
                this.executorThread = oldThread;
                this.endSyncExec.release();
            }
        }
        finally {
            this.executorThread = oldThread;
            this.endSyncExec.release();
        }
    }

    public void asyncExec(Runnable runnable) {
        if (this.executorThread == Thread.currentThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("asyncExec failed", t);
            }
            return;
        }
        this.queue(runnable);
    }

    public void setSimulationStepNs(long ns) {
        this.simulationStepNs = ns;
        this.stepInSeconds = BigDecimal.valueOf(this.simulationStepNs).multiply(BigDecimal.valueOf(1.0E-9)).doubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDuration(long ns) {
        this.runStart = System.nanoTime();
        this.runTimeNs = 0L;
        this.endTimeNs = ns;
        ArrayList<Runnable> arrayList = this.tasks;
        synchronized (arrayList) {
            this.changeState(ExperimentState.RUNNING);
            this.tasks.notify();
        }
    }

    public ExperimentState getExperimentState() {
        return this.state;
    }

    public ExperimentState getState(ReadGraph graph) throws DatabaseException {
        graph.syncRequest((ExternalRead)this.stateRead);
        return this.state;
    }

    public void changeState(ExperimentState state) {
        this.state = state;
        this.stateRead.fire();
    }

    public class StateExternalRead
    extends ParametrizedPrimitiveRead<Realm, Integer> {
        private int value;
        private Listener<Integer> listener;

        public StateExternalRead(Realm parameter) {
            super((Object)parameter);
            this.value = 0;
            this.listener = null;
        }

        public void register(ReadGraph graph, Listener<Integer> procedure) {
            procedure.execute((Object)this.value);
            if (procedure.isDisposed()) {
                return;
            }
            if (this.listener != null) {
                throw new RuntimeDatabaseException("Internal error");
            }
            this.listener = procedure;
        }

        public void unregistered() {
            this.listener = null;
        }

        public void fire() {
            ++this.value;
            if (this.listener != null) {
                this.listener.execute((Object)this.value);
            }
        }
    }
}

