/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.district.network.ModelledCRS;
import org.simantics.district.network.ui.adapters.DistrictNetworkVertex;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictNetworkVertexNode
extends G2DNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistrictNetworkVertexNode.class);
    private static final long serialVersionUID = -2641639101400236719L;
    private DistrictNetworkVertex vertex;
    private static final double left = -0.5;
    private static final double top = -0.5;
    private static final double width = 1.0;
    private static final double height = 1.0;
    private static final Rectangle2D NORMAL = new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0);
    private static final Rectangle2D HOVERED = new Rectangle2D.Double(-1.5, -1.5, 3.0, 3.0);
    private Stroke stroke = new BasicStroke(2.0f);
    private boolean scaleStroke = true;
    private boolean hover;
    private Color color;
    private Rectangle2D bounds;

    public void init() {
        this.setZIndex(2);
    }

    public void render(Graphics2D g2d) {
        AffineTransform ot = null;
        AffineTransform t = this.getTransform();
        if (t != null && !t.isIdentity()) {
            ot = g2d.getTransform();
            g2d.transform(this.getTransform());
        }
        Object aaHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        g2d.setColor(this.color);
        double scaleRecip = 1.0;
        if (this.scaleStroke) {
            double scale = GeometryUtils.getScale((AffineTransform)g2d.getTransform());
            scaleRecip = 1.0 / scale;
        }
        Point2D res = DistrictNetworkVertexNode.calculatePoint2D(this.vertex);
        Rectangle2D.Double toDraw = this.hover ? new Rectangle2D.Double(res.getX() - HOVERED.getWidth() / 2.0 * scaleRecip, res.getY() - HOVERED.getHeight() / 2.0 * scaleRecip, HOVERED.getWidth() * scaleRecip, HOVERED.getHeight() * scaleRecip) : new Rectangle2D.Double(res.getX() - NORMAL.getWidth() / 2.0 * (scaleRecip *= 8.0), res.getY() - NORMAL.getHeight() / 2.0 * scaleRecip, NORMAL.getWidth() * scaleRecip, NORMAL.getHeight() * scaleRecip);
        g2d.fill(toDraw);
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    public Rectangle2D getBounds() {
        return super.getBounds();
    }

    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    private void updateBounds() {
        Rectangle2D oldBounds = this.bounds;
        if (oldBounds == null) {
            oldBounds = new Rectangle2D.Double();
        }
        this.bounds = this.calculateBounds(oldBounds);
    }

    public void setTransform(AffineTransform transform) {
        super.setTransform(transform);
        this.updateBounds();
    }

    public AffineTransform getTransform() {
        return super.getTransform();
    }

    private Rectangle2D calculateBounds(Rectangle2D rect) {
        Point2D calcPoint = DistrictNetworkVertexNode.calculatePoint2D(this.vertex);
        AffineTransform at = this.getTransform();
        return new Rectangle2D.Double(calcPoint.getX(), calcPoint.getY(), 1.0 / at.getScaleX(), 1.0 / at.getScaleY()).getBounds2D();
    }

    private static Point2D calculatePoint2D(DistrictNetworkVertex vertex) {
        Point2D point = vertex.getPoint();
        double x = ModelledCRS.longitudeToX((double)point.getX());
        double y = ModelledCRS.latitudeToY((double)point.getY());
        Point2D.Double res = new Point2D.Double(x, y);
        return res;
    }

    public void setVertex(DistrictNetworkVertex vertex) {
        this.vertex = vertex;
        this.updateBounds();
    }

    public boolean hover(boolean hover) {
        boolean changed = false;
        if (this.hover != hover) {
            this.hover = hover;
            changed = true;
        }
        return changed;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }
}

