/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.function;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.browsing.ui.graph.impl.GraphEnumerationModifier;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.adapters.NewCompositeActionFactory;
import org.simantics.modeling.typicals.TypicalUtil;
import org.simantics.operation.Layer0X;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.ui.workbench.action.DefaultActions;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Functions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Functions.class);

    private Functions() {
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object defaultEdgeMappingModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Resource diagram = Functions.resolveElement(graph, context);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        return Functions.baseMappingModifier(graph, diagram, DN.EdgeDefaultMapping, DN.Mapping_EdgeMapping, context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object defaultVertexMappingModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        System.out.println(graph.getURI(resource));
        System.out.println(context.getURI(graph));
        Resource diagram = Functions.resolveElement(graph, context);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        return Functions.baseMappingModifier(graph, diagram, DN.VertexDefaultMapping, DN.Mapping_VertexMapping, context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object mappingModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Resource element = Functions.resolveElement(graph, context);
        Resource mappingType = Functions.resolveMappingType(graph, element);
        return Functions.baseMappingModifier(graph, element, DistrictNetworkResource.getInstance((ReadGraph)graph).HasMapping, mappingType, context);
    }

    public static Map<String, Resource> getVertexMappings(ReadGraph graph, Resource resource) throws DatabaseException {
        Map<String, Resource> second = Functions.getNetworkMappingsByType(graph, resource, DistrictNetworkResource.getInstance((ReadGraph)graph).Mapping_VertexMapping);
        return second;
    }

    public static Map<String, Resource> getEdgeMappings(ReadGraph graph, Resource resource) throws DatabaseException {
        Map<String, Resource> second = Functions.getNetworkMappingsByType(graph, resource, DistrictNetworkResource.getInstance((ReadGraph)graph).Mapping_EdgeMapping);
        return second;
    }

    public static Map<String, Resource> getCRSs(ReadGraph graph, Resource resource) throws DatabaseException {
        Map<String, Resource> result = Functions.getNetworkMappingsByType(graph, resource, DistrictNetworkResource.getInstance((ReadGraph)graph).SpatialRefSystem);
        return result;
    }

    public static Map<String, Resource> getNetworkMappingsByType(ReadGraph graph, Resource element, Resource mappingType) throws DatabaseException {
        Resource indexRoot = (Resource)graph.sync((ReadInterface)new IndexRoot(element));
        List mappings = ModelingUtils.searchByType((ReadGraph)graph, (Resource)indexRoot, (Resource)mappingType);
        HashMap<String, Resource> result = new HashMap<String, Resource>(mappings.size());
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        mappings.forEach(mapping -> {
            try {
                String name = (String)graph.getRelatedValue2(mapping, layer0.HasName);
                Resource existing = result.put(name, (Resource)mapping);
                if (existing != null) {
                    LOGGER.warn("Duplicate mapping name! {} {} and existing is {}", new Object[]{name, mapping, existing});
                }
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        });
        return result;
    }

    private static Object baseMappingModifier(ReadGraph graph, Resource element, Resource property, Resource mappingType, Variable context) throws DatabaseException {
        Resource indexRoot = (Resource)graph.sync((ReadInterface)new IndexRoot(element));
        List mappings = ModelingUtils.searchByType((ReadGraph)graph, (Resource)indexRoot, (Resource)mappingType);
        Enumeration enums = Enumeration.make(mappings.stream().map(m -> Functions.createEnumeratedValue(graph, m)).collect(Collectors.toList()));
        Resource currentMapping = graph.getSingleObject(element, property);
        return new HasMappingEnumerationModifier(Simantics.getSession(), element, property, (Enumeration<Resource>)enums, currentMapping);
    }

    private static Resource resolveMappingType(ReadGraph graph, Resource element) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(element, DN.Edge)) {
            return DN.Mapping_EdgeMapping;
        }
        if (graph.isInstanceOf(element, DN.Vertex)) {
            return DN.Mapping_VertexMapping;
        }
        throw new IllegalStateException("No mapping type found for element " + element + " : " + graph.getPossibleURI(element));
    }

    private static Resource resolveElement(ReadGraph graph, Variable variable) throws DatabaseException {
        Variables.Role role = variable.getPossibleRole(graph);
        if (role.equals((Object)Variables.Role.PROPERTY)) {
            return Functions.resolveElement(graph, variable.getParent(graph));
        }
        return variable.getRepresents(graph);
    }

    private static EnumeratedValue<Resource> createEnumeratedValue(ReadGraph graph, Resource resource) {
        try {
            String label = NameLabelUtil.modalName((ReadGraph)graph, (Resource)resource);
            return new EnumeratedValue(label, (Object)resource);
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException((Throwable)e);
        }
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object enumerationValues(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        Variable var = (Variable)context;
        System.out.println(graph.getURI(resource));
        System.out.println(var.getURI(graph));
        return Collections.emptyList();
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object convertToValue(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return graph.getRelatedValue2(resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
    }

    @SCLValue(type="Resource -> String -> Resource -> Resource")
    public static Resource compositeInstantiator(Resource compositeType, String defaultName, Resource target) throws DatabaseException {
        return (Resource)TypicalUtil.syncExec(procedure -> {
            if (!SWTUtils.asyncExec((Display)PlatformUI.getWorkbench().getDisplay(), () -> {
                try {
                    Functions.queryInitialValuesAndCreateComposite(compositeType, target, defaultName, (Procedure<Resource>)procedure);
                }
                catch (Throwable t) {
                    procedure.exception(t);
                }
            })) {
                procedure.execute(null);
            }
        });
    }

    private static void queryInitialValuesAndCreateComposite(Resource compositeType, Resource target, String defaultName, final Procedure<Resource> procedure) {
        final DefaultMappingsDialog dialog = new DefaultMappingsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), target);
        if (dialog.open() != 0) {
            procedure.execute(null);
            return;
        }
        Simantics.getSession().asyncRequest(NewCompositeActionFactory.createCompositeRequest((Resource)target, (String)defaultName, (Resource)compositeType), (Procedure)new Procedure<Resource>(){

            public void execute(final Resource composite) {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                        Resource diagram = graph.getSingleObject(composite, ModelingResources.getInstance((ReadGraph)graph).CompositeToDiagram);
                        graph.claim(diagram, DN.EdgeDefaultMapping, dialog.getDefaultEdgeMapping());
                        graph.claim(diagram, DN.VertexDefaultMapping, dialog.getDefaultVertexMapping());
                        graph.claim(diagram, DN.HasSpatialRefSystem, dialog.getCRS());
                        String compositeName = (String)graph.getRelatedValue2(composite, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
                        graph.claimLiteral(diagram, Layer0X.getInstance((ReadGraph)graph).HasGeneratedNamePrefix, (Object)("N" + compositeName.substring(compositeName.length() - 1, compositeName.length())));
                    }
                });
                DefaultActions.asyncPerformDefaultAction((Session)Simantics.getSession(), (Object)composite, (boolean)false, (boolean)false, (boolean)true);
                procedure.execute((Object)composite);
            }

            public void exception(Throwable t) {
                LOGGER.error("Failed to create composite, see exception for details.", t);
                procedure.exception(t);
            }
        });
    }

    public static Collection<Resource> getDistrictDiagrams(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection indexRoots = (Collection)graph.sync((ReadInterface)new ObjectsWithType(Simantics.getProjectResource(), L0.ConsistsOf, L0.IndexRoot));
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        HashSet<Resource> results = new HashSet<Resource>();
        for (Resource indexRoot : indexRoots) {
            List diagrams = ModelingUtils.searchByType((ReadGraph)graph, (Resource)indexRoot, (Resource)DN.Diagram);
            results.addAll(diagrams);
        }
        return results;
    }

    private static class DefaultMappingsDialog
    extends SelectionStatusDialog {
        private Combo vertexMappingCombo;
        private Combo edgeMappingCombo;
        private Combo crsCombo;
        private Composite composite;
        private Resource configuration;
        private Map<String, Resource> vertexMappings = new HashMap<String, Resource>();
        private Map<String, Resource> edgeMappings = new HashMap<String, Resource>();
        private Map<String, Resource> composites = new HashMap<String, Resource>();
        private Map<String, Resource> crss = new HashMap<String, Resource>();
        private Map<String, Map<String, Resource>> components = new HashMap<String, Map<String, Resource>>();
        private Resource defaultVertexMapping;
        private Resource defaultEdgeMapping;
        private Resource defaultCRS;
        private Combo compositeMappingCombo;
        private Combo componentMappingCombo;

        protected DefaultMappingsDialog(Shell parentShell, Resource configuration) {
            super(parentShell);
            this.configuration = configuration;
            this.setTitle("Select mappings for new DN diagram");
        }

        public Resource getDefaultVertexMapping() {
            return this.defaultVertexMapping;
        }

        public Resource getDefaultEdgeMapping() {
            return this.defaultEdgeMapping;
        }

        protected Control createDialogArea(Composite parent) {
            this.composite = (Composite)super.createDialogArea(parent);
            this.createMappingsGroup(this.composite);
            this.createExistingCompositeGroup(this.composite);
            this.createCRSSettingsGroup(this.composite);
            Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    vertexMappings = Functions.getVertexMappings(graph, configuration);
                    edgeMappings = Functions.getEdgeMappings(graph, configuration);
                    composites = this.getComposites(graph, configuration);
                    if (composites.size() > 0) {
                        components = this.getComponents(graph, (Resource)composites.get(0));
                    }
                    crss = Functions.getCRSs(graph, configuration);
                    composite.getDisplay().asyncExec(() -> {
                        vertexMappingCombo.setItems(vertexMappings.keySet().toArray(new String[vertexMappings.size()]));
                        edgeMappingCombo.setItems(edgeMappings.keySet().toArray(new String[edgeMappings.size()]));
                        crsCombo.setItems(crss.keySet().toArray(new String[crss.size()]));
                        compositeMappingCombo.setItems(composites.keySet().toArray(new String[composites.size()]));
                        vertexMappingCombo.select(0);
                        edgeMappingCombo.select(0);
                        crsCombo.select(0);
                        if (!composites.isEmpty()) {
                            compositeMappingCombo.select(0);
                        }
                    });
                }
            });
            return this.composite;
        }

        protected Map<String, Map<String, Resource>> getComponents(ReadGraph graph, Resource resource) {
            return null;
        }

        protected Map<String, Resource> getComposites(ReadGraph graph, Resource element) throws DatabaseException {
            Resource indexRoot = (Resource)graph.sync((ReadInterface)new IndexRoot(element));
            ModelingUtils.searchByType((ReadGraph)graph, (Resource)indexRoot, (Resource)DiagramResource.getInstance((ReadGraph)graph).Diagram);
            List<Resource> nonDistrictComposites = this.composites.values().stream().filter(comp -> {
                try {
                    return !graph.isInstanceOf(comp, DistrictNetworkResource.getInstance((ReadGraph)readGraph).Composite);
                }
                catch (ServiceException serviceException) {
                    LOGGER.error("Could not check if composite " + comp + " is instanceOf DistrictNetwork.composite");
                    return false;
                }
            }).collect(Collectors.toList());
            HashMap<String, Resource> result = new HashMap<String, Resource>(nonDistrictComposites.size());
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            nonDistrictComposites.forEach(mapping -> {
                try {
                    String name = (String)graph.getRelatedValue2(mapping, layer0.HasName);
                    result.put(name, (Resource)mapping);
                }
                catch (DatabaseException e) {
                    LOGGER.error("Could not read name of " + mapping, (Throwable)e);
                }
            });
            return result;
        }

        private void createMappingsGroup(Composite parent) {
            Group group = new Group(parent, 0);
            group.setFont(parent.getFont());
            group.setText("Default mappings");
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            group.setLayout((Layout)new GridLayout(1, false));
            Composite cmposite = new Composite((Composite)group, 0);
            cmposite.setLayoutData((Object)new GridData(4, 128, true, false));
            cmposite.setLayout((Layout)new GridLayout(2, false));
            Label vertexMappingLabel = new Label(cmposite, 0);
            vertexMappingLabel.setText("Default vertex mapping");
            this.vertexMappingCombo = new Combo(cmposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.vertexMappingCombo);
            Label edgeMappingLabel = new Label(cmposite, 0);
            edgeMappingLabel.setText("Default edge mapping");
            this.edgeMappingCombo = new Combo(cmposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.edgeMappingCombo);
        }

        private void createExistingCompositeGroup(Composite parent) {
            Group group = new Group(parent, 0);
            group.setFont(parent.getFont());
            group.setText("Mapped composite");
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            group.setLayout((Layout)new GridLayout(1, false));
            Composite cmposite = new Composite((Composite)group, 0);
            cmposite.setLayoutData((Object)new GridData(4, 128, true, false));
            cmposite.setLayout((Layout)new GridLayout(2, false));
            Label compositeMappingLabel = new Label(cmposite, 0);
            compositeMappingLabel.setText("Select composite");
            this.compositeMappingCombo = new Combo(cmposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.compositeMappingCombo);
            this.compositeMappingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    this.recalculateMappapleComponents();
                }
            });
            Label compojnentMappingLabel = new Label(cmposite, 0);
            compojnentMappingLabel.setText("Select component");
            this.componentMappingCombo = new Combo(cmposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.componentMappingCombo);
        }

        protected void recalculateMappapleComponents() {
            Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    composite.getDisplay().asyncExec(() -> {});
                }
            });
        }

        private void createCRSSettingsGroup(Composite parent) {
            Group group = new Group(parent, 0);
            group.setFont(parent.getFont());
            group.setText("CRS settings");
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            group.setLayout((Layout)new GridLayout(1, false));
            Composite cmposite = new Composite((Composite)group, 0);
            cmposite.setLayoutData((Object)new GridData(4, 128, true, false));
            cmposite.setLayout((Layout)new GridLayout(2, false));
            Label vertexMappingLabel = new Label(cmposite, 0);
            vertexMappingLabel.setText("Default CRS");
            this.crsCombo = new Combo(cmposite, 2056);
            GridData textData = new GridData(4, 0x1000000, true, false);
            this.crsCombo.setLayoutData((Object)textData);
        }

        protected void computeResult() {
            this.defaultVertexMapping = this.vertexMappings.get(this.vertexMappingCombo.getItem(this.vertexMappingCombo.getSelectionIndex()));
            this.defaultEdgeMapping = this.edgeMappings.get(this.edgeMappingCombo.getItem(this.edgeMappingCombo.getSelectionIndex()));
            this.defaultCRS = this.crss.get(this.crsCombo.getItem(this.crsCombo.getSelectionIndex()));
        }

        public Resource getCRS() {
            return this.defaultCRS;
        }
    }

    private static class HasMappingEnumerationModifier
    extends GraphEnumerationModifier {
        public HasMappingEnumerationModifier(Session session, Resource subject, Resource relation, Enumeration<Resource> enumeration, Resource value) {
            super(session, subject, relation, enumeration, value);
        }
    }
}

