/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.adapters;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import org.simantics.district.network.ui.DistrictNetworkEdge;
import org.simantics.district.network.ui.adapters.DistrictNetworkAdditionalColor;
import org.simantics.district.network.ui.nodes.DistrictNetworkEdgeNode;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictNetworkEdgeElement {
    public static final IHintContext.Key KEY_DN_EDGE = new IHintContext.KeyOf(DistrictNetworkEdge.class, "DN_EDGE");
    public static final IHintContext.Key KEY_DN_EDGE_NODE = new SceneGraphNodeKey(DistrictNetworkEdgeNode.class, "DN_EDGE_NODE");
    public static final ElementClass CLASS = ElementClass.compile((ElementHandler[])new ElementHandler[]{DefaultTransform.INSTANCE, DNEdgeInternalSize.INSTANCE, DNEdgeSceneGraph.INSTANCE, DNEdgeConnectionHandler.INSTANCE, SimpleElementLayers.INSTANCE, DistrictNetworkAdditionalColor.INSTANCE}).setId(DistrictNetworkEdgeElement.class.getSimpleName());

    static class DNEdgeConnectionHandler
    implements ConnectionHandler {
        private static final long serialVersionUID = -410377314637446238L;
        public static final DNEdgeConnectionHandler INSTANCE = new DNEdgeConnectionHandler();

        DNEdgeConnectionHandler() {
        }

        public Collection<IElement> getChildren(IElement connection, Collection<IElement> result) {
            return Collections.emptyList();
        }

        public Collection<IElement> getBranchPoints(IElement connection, Collection<IElement> result) {
            return Collections.emptyList();
        }

        public Collection<IElement> getSegments(IElement connection, Collection<IElement> result) {
            return Collections.emptyList();
        }

        public Collection<Topology.Connection> getTerminalConnections(IElement connection, Collection<Topology.Connection> result) {
            return Collections.emptyList();
        }
    }

    static final class DNEdgeInternalSize
    implements InternalSize {
        private static final Logger LOGGER = LoggerFactory.getLogger(DNEdgeInternalSize.class);
        private static final long serialVersionUID = -2725017034692179676L;
        public static final DNEdgeInternalSize INSTANCE = new DNEdgeInternalSize();

        DNEdgeInternalSize() {
        }

        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            DistrictNetworkEdge edge = (DistrictNetworkEdge)e.getHint(KEY_DN_EDGE);
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            if (edge != null) {
                size.setFrame(DistrictNetworkEdgeNode.calculatePath(edge).getBounds2D());
            } else {
                LOGGER.debug("Element {} does not have edge!", (Object)e);
            }
            return size;
        }
    }

    static final class DNEdgeSceneGraph
    implements SceneGraph {
        public static final DNEdgeSceneGraph INSTANCE = new DNEdgeSceneGraph();
        private static final long serialVersionUID = 8894367073815556871L;

        DNEdgeSceneGraph() {
        }

        public void init(IElement edgeElement, G2DParentNode parent) {
            DistrictNetworkEdge edge = (DistrictNetworkEdge)edgeElement.getHint(KEY_DN_EDGE);
            if (edge == null) {
                this.cleanup(edgeElement);
            } else {
                DistrictNetworkEdgeNode node = (DistrictNetworkEdgeNode)((Object)edgeElement.getHint(KEY_DN_EDGE_NODE));
                if (node == null) {
                    node = (DistrictNetworkEdgeNode)((Object)parent.addNode(ElementUtils.generateNodeId((IElement)edgeElement), DistrictNetworkEdgeNode.class));
                    edgeElement.setHint(KEY_DN_EDGE_NODE, (Object)node);
                }
                node.setColor(ElementUtils.getAdditionalColor((IElement)edgeElement, (Color)Color.BLUE));
                node.setDNEdge(edge);
                AffineTransform at = ElementUtils.getTransform((IElement)edgeElement);
                if (at != null) {
                    node.setTransform(at);
                }
            }
        }

        public void cleanup(IElement edge) {
            ElementUtils.removePossibleNode((IElement)edge, (IHintContext.Key)KEY_DN_EDGE_NODE);
            edge.removeHint(KEY_DN_EDGE_NODE);
        }
    }
}

