/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.simantics.district.network.ui.adapters.DistrictNetworkVertexElement;
import org.simantics.district.network.ui.nodes.DistrictNetworkVertexNode;
import org.simantics.district.network.ui.nodes.NetworkDrawingNode;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class NetworkDrawingParticipant
extends AbstractDiagramParticipant {
    @DependencyReflection.Dependency
    PickContext pick;
    public static final IHintContext.Key KEY_PICK_DISTANCE = new IHintContext.KeyOf(Double.class, "PICK_DISTANCE");
    public static final double PICK_DIST = 10.0;
    private NetworkDrawingNode node;
    private AffineTransform transform;

    public NetworkDrawingParticipant(AffineTransform transform) {
        this.transform = transform;
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.node = (NetworkDrawingNode)((Object)parent.addNode("networkDrawingNode", NetworkDrawingNode.class));
        this.node.setTransform(this.transform);
        this.node.setNetworkDrawingParticipant(this);
    }

    protected void onDiagramSet(IDiagram newDiagram, IDiagram oldDiagram) {
        this.node.setDiagram(newDiagram);
    }

    public boolean pickHoveredElement(Point2D currentMousePos) {
        G2DNode node;
        PickRequest req = new PickRequest(currentMousePos.getX(), currentMousePos.getY());
        ArrayList pickables = new ArrayList();
        this.pick.pick(this.diagram, req, pickables);
        ArrayList snap = new ArrayList(this.diagram.getSnapshot());
        snap.removeAll(pickables);
        boolean changed = false;
        for (IElement sn : snap) {
            node = (G2DNode)sn.getHint(DistrictNetworkVertexElement.KEY_DN_VERTEX_NODE);
            if (!(node instanceof DistrictNetworkVertexNode) || !((DistrictNetworkVertexNode)node).hover(false) || changed) continue;
            changed = true;
        }
        for (IElement elem : pickables) {
            node = (G2DNode)elem.getHint(DistrictNetworkVertexElement.KEY_DN_VERTEX_NODE);
            if (!(node instanceof DistrictNetworkVertexNode) || !((DistrictNetworkVertexNode)node).hover(true) || changed) continue;
            changed = true;
        }
        return changed;
    }
}

