/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.team.ui.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.Resource;
import org.simantics.db.ServerReference;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.TeamSupport;
import org.simantics.team.Activator;
import org.simantics.team.Utils;
import org.simantics.team.internal.StagingLauncher;
import org.simantics.team.internal.StagingLauncher.Config;
import org.simantics.team.internal.StagingLauncher.StagingResult;
import org.simantics.team.ui.StageInitWizard;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.handler.AbstractPreferenceHandler;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.dialogs.ShowError;

public class SynchroniseAllHandler extends AbstractPreferenceHandler {

    public SynchroniseAllHandler() {
        super(Activator.getDefault());
    }
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        System.out.println("DEBUG: SynchronizeAllHandler");
//        ISelection sel = HandlerUtil.getCurrentSelection(event);
//        IStructuredSelection ss = StructuredSelection.EMPTY;
//        if (sel instanceof IStructuredSelection)
//            ss = (IStructuredSelection) sel;
        try {
            Session session = SimanticsUI.getSession();
            File wsFolder = new File(Platform.getInstanceLocation().getURL().getFile());
            File stFolder = new File(wsFolder, "staging");
            File teamFolder = pullAll(session, Utils.getTeamFolder(), stFolder);
            if (null == teamFolder)
                return null; // User cancelled operation.
            show(session, teamFolder, stFolder);
        } catch (DatabaseException e) {
            ShowError.showError("Staging In.", "Staging failed", e);
        }
        return null;
    }
    static File pullAll(Session session, File teamFolder, File stFolder)
    throws DatabaseException {
        File dbFolder = new File(stFolder, "db");
        try {
            FileUtils.deleteAll(dbFolder);
            File tempFolder = new File(stFolder, "temp");
            FileUtils.deleteAll(tempFolder);
            File indexingFolder = new File(stFolder, ".metadata/.plugins/org.simantics.db.indexing");
            FileUtils.deleteAll(indexingFolder);
            File procoreFolder = new File(stFolder, "metadata/.plugins/org.simantics.db.procore");
            FileUtils.deleteAll(procoreFolder);
        } catch (IOException e) {
            throw new DatabaseException("Pull failed.", e);
        }
        if (null == teamFolder || !teamFolder.isDirectory()) {
            final StageInitWizard.Data data = new StageInitWizard.Data(stFolder, null);
            data.requireExisting = true;
            if (!StageInitWizard.openInitWizard(data)) {
                Utils.setTeamFolder(null);
                return null; // User cancelled the operation.
            }
            teamFolder = data.teamFolder;
            assert(null != teamFolder);
        }
        TeamSupport ts = session.getService(TeamSupport.class);
        ts.pull(teamFolder, dbFolder);
        return teamFolder;
    }
    static void show(Session session, File teamFolder, File wsFolder) {
        final IProgressMonitor monitor = new NullProgressMonitor();
        try {
            monitor.beginTask("begin", 1300);
            LifecycleSupport lfs = session.getService(LifecycleSupport.class);
            ServerReference sref = lfs.getSessionReference().getServerReference();
//            SerialisationSupport ss = session.getService(SerialisationSupport.class);
            String randomAccessId = "target"; // String.valueOf(ss.getRandomAccessId(target));
            Resource targetLibrary = null;
            final Config config = new Config(session, targetLibrary, wsFolder, teamFolder);
            config.titlePrefix = wsFolder.getName();
            StagingResult result = StagingLauncher.launch(config, sref.toString(), randomAccessId);
            if (result.getExitValue() != 0) {
                String msg = "";
                if (result.getLogFile().exists()) {
                    byte[] data = FileUtils.readFile(result.getLogFile());
                    msg = new String(data, Charset.defaultCharset());
                }
                if (msg.isEmpty() || msg.matches(" *"))
                    msg = "Staging crashed and burned. Contact application support.";
                ShowError.showError("Staging failed, errorcode="+result.getExitValue(), msg, new Exception());
            }
            if (result.getMessageLog() != null) {
                MessageDialog.openError(PlatformUI.getWorkbench().getDisplay().getActiveShell(),
                        "Staging failed",
                        result.getMessageLog());
            }
            } catch (Exception e) {
                ErrorLogger.defaultLogError(e);
            } finally {
                monitor.done();
            }
    }
}
