/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.mapping.IContextualModification;

public class PrintStateInstruction implements IInstruction {
	String position;

	public PrintStateInstruction(String position) {
		this.position = position;
	}
	
	private void print(ReadGraph g, Object[] bindings) {
		System.out.print(position + ": ");
		boolean first = true;
		for(Object obj : bindings) {
			if(first)
				first = false;
			else
				System.out.print(", ");
			System.out.print(obj);
		}
		System.out.println();
	}
	
	@Override
	public Object query(ReadGraph g, Object[] bindings) {
		print(g, bindings);
		return null;
	}
	
	@Override
	public Object next(ReadGraph g, Object[] bindings, Object continuation) {		
		return IInstruction.FAILURE;
	}	

	@Override
	public IContextualModification claim(ReadGraph g, Object[] bindings) {
		print(g, bindings);
		return null;
	}

	@Override
	public IContextualModification deny(ReadGraph g, Object[] bindings) {
		print(g, bindings);
		return null;
	}

	@Override
	public void doClaim(WriteGraph g, Object[] bindings) {
		print(g, bindings);
	}

	@Override
	public void doDeny(WriteGraph g, Object[] bindings) {
		print(g, bindings);
	}

	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
		/* Because this instruction is for debugging, it doesn't affect
		   to the set of read variables. */
	}

	@Override
	public void mapVariables(TIntIntHashMap map) {
	}	
	
	@Override
	public void toString(StringBuilder b, int indent) {
		
	}
	
}
