/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint.instructions;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class OrInstruction extends CombinedInstruction {
	
	public OrInstruction(IInstruction... instructions) {
		super(instructions);
	}

	static class Continuation {
		Object continuation;
		int instructionId;	
		
		public Continuation(Object continuation, int instructionId) {
			this.continuation = continuation;
			this.instructionId = instructionId;
		}
	}
	
	@Override
	public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
		int instructionId;
		for(instructionId=0;instructionId<instructions.length-1;++instructionId) {
			if(DEBUG)
				System.out.println("OrInstruction.query " + instructionId + "/" + instructions.length);
			Object continuation = instructions[instructionId].query(g, bindings);
			if(continuation != IInstruction.FAILURE)
				return new Continuation(continuation, instructionId);
		}
		return instructions[instructionId].query(g, bindings);
	}
	
	@Override
	public Object next(ReadGraph g, Object[] bindings, Object ret_) throws DatabaseException {
		Continuation ret = (Continuation)ret_;
		int instructionId = ret.instructionId;
		Object continuation = ret.continuation;
		
		if(continuation != null) {
			continuation = instructions[instructionId].next(g, bindings, continuation);
			if(continuation != IInstruction.FAILURE) {
				ret.continuation = continuation;
				return ret;
			}
		}
		
		for(++instructionId;instructionId<instructions.length-1;++instructionId) {
			continuation = instructions[instructionId].query(g, bindings);
			if(continuation != IInstruction.FAILURE) {
				ret.continuation = continuation;
				ret.instructionId = instructionId;				
				return ret;
			}
		}
		return instructions[instructionId].query(g, bindings);
	}

	@Override
	public void toString(StringBuilder b, int indent) {		
		b.append("(    ");
		boolean first = true;
		for(IInstruction inst : instructions) {
			if(first)
				first = false;
			else {
				b.append(";\n");
				for(int i=0;i<indent+1;++i)
					b.append(INDENTATION);
			}
			inst.toString(b, indent + 1);			
		}
		b.append('\n');
		for(int i=0;i<indent;++i)
			b.append(INDENTATION);
		b.append(")");		
	}
}
